/*
 * module.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * foCXELFIuWFNgt@CJ[lɃ[h
 */


#include <sys/types.h>
#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>


/******************************************************************************************************
 *
 * 
 *
 *******************************************************************************************************/


//================================== PRIVATE ============================================

/*
 * 
 *
 */
static int get_file_header(FILE *file)
{
	/* Read in the identity array.  */
	if (fread(elf_header.e_ident, EI_NIDENT, 1, file) != 1) {
		return 0;
	}

	/* Determine how to read the rest of the header.  */
	switch (elf_header.e_ident[EI_DATA]) {
	case ELFDATA2LSB:
		byte_get = byte_get_little_endian;
		byte_put = byte_put_little_endian;
		break;
	case ELFDATA2MSB:
		byte_get = byte_get_big_endian;
		byte_put = byte_put_big_endian;
		break;
	default:
		return 0;
	}

	/* For now we only support 32 bit and 64 bit ELF files.  */
	is_32bit_elf = (elf_header.e_ident[EI_CLASS] != ELFCLASS64);

	/* Read in the rest of the header.  */
	if (is_32bit_elf) {
		Elf32_External_Ehdr ehdr32;

		if (fread(ehdr32.e_type, sizeof(ehdr32) - EI_NIDENT, 1, file) != 1) {
			return 0;
		}

		elf_header.e_type      = BYTE_GET(ehdr32.e_type);
		elf_header.e_machine   = BYTE_GET(ehdr32.e_machine);
		elf_header.e_version   = BYTE_GET(ehdr32.e_version);
		elf_header.e_entry     = BYTE_GET(ehdr32.e_entry);
		elf_header.e_phoff     = BYTE_GET(ehdr32.e_phoff);
		elf_header.e_shoff     = BYTE_GET(ehdr32.e_shoff);
		elf_header.e_flags     = BYTE_GET(ehdr32.e_flags);
		elf_header.e_ehsize    = BYTE_GET(ehdr32.e_ehsize);
		elf_header.e_phentsize = BYTE_GET(ehdr32.e_phentsize);
		elf_header.e_phnum     = BYTE_GET(ehdr32.e_phnum);
		elf_header.e_shentsize = BYTE_GET(ehdr32.e_shentsize);
		elf_header.e_shnum     = BYTE_GET(ehdr32.e_shnum);
		elf_header.e_shstrndx  = BYTE_GET(ehdr32.e_shstrndx);
	}
	else {
		Elf64_External_Ehdr ehdr64;

		/* If we have been compiled with sizeof (bfd_vma) == 4, then
		 we will not be able to cope with the 64bit data found in
		 64 ELF files.  Detect this now and abort before we start
		 overwriting things.  */
		if (sizeof (bfd_vma) < 8) {
			error("This instance of readelf has been built without support for a\n\
				64 bit data type and so it cannot read 64 bit ELF files.\n");
			return 0;
		}

		if (fread (ehdr64.e_type, sizeof(ehdr64) - EI_NIDENT, 1, file) != 1) {
			return 0;
		}

		elf_header.e_type      = BYTE_GET(ehdr64.e_type);
		elf_header.e_machine   = BYTE_GET(ehdr64.e_machine);
		elf_header.e_version   = BYTE_GET(ehdr64.e_version);
		elf_header.e_entry     = BYTE_GET(ehdr64.e_entry);
		elf_header.e_phoff     = BYTE_GET(ehdr64.e_phoff);
		elf_header.e_shoff     = BYTE_GET(ehdr64.e_shoff);
		elf_header.e_flags     = BYTE_GET(ehdr64.e_flags);
		elf_header.e_ehsize    = BYTE_GET(ehdr64.e_ehsize);
		elf_header.e_phentsize = BYTE_GET(ehdr64.e_phentsize);
		elf_header.e_phnum     = BYTE_GET(ehdr64.e_phnum);
		elf_header.e_shentsize = BYTE_GET(ehdr64.e_shentsize);
		elf_header.e_shnum     = BYTE_GET(ehdr64.e_shnum);
		elf_header.e_shstrndx  = BYTE_GET(ehdr64.e_shstrndx);
	}

	if (elf_header.e_shoff) {
		/* There may be some extensions in the first section header.  Don't bomb if we can't read it.  */
		if (is_32bit_elf) {
			get_32bit_section_headers(file, 1);
		}
		else {
			get_64bit_section_headers(file, 1);
		}
	}

	return 1;
}

static void usage(void)
{
	fprintf(stdout, "Usage: moduel elf-object\n");

	exit (0);
}

//================================== PUBLIC =============================================

int main(int argc, char *argv[])
{
	FILE *file;
	const char *fileName;

	if (argc < 2){
		usage();
	}

	fileName = argv[1];
	file = fopen(fileName, "rb");
	if (file == NULL) {
		error("Input file '%s' can't open.\n", fileName);
		return 1;
	}
	rewind(file);

	// ELFIuWFNgt@CH

	fclose(file);

	return 0;
}
