/*
 * stdio.h
 */


#ifndef stdio_h
#define stdio_h


#include <sys/types.h>
#include <sys/cdefs.h>
#include <unistd.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>


enum{
	FILENAME_MAX = NAME_MAX,	/* Maximum size in bytes of the longest filename string. */
	FOPEN_MAX = STREAM_MAX	/* Number of streams.The value is at least eight. */
};


/*
 * The following three definitions are for ANSI C, which took them
 * from System V, which brilliantly took internal interface macros and
 * made them official arguments to setvbuf(), without renaming them.
 * Hence, these ugly _IOxxx names are *supposed* to appear in user code.
 *
 * Although numbered as their counterparts above, the implementation
 * does not rely on this.
 */
#define	_IOFBF	0		/* setvbuf should set fully buffered */
#define	_IOLBF	1		/* setvbuf should set line buffered */
#define	_IONBF	2		/* setvbuf should set unbuffered */

#define	BUFSIZ	1024		/* size of buffer used by setbuf */
#define	EOF	(-1)
#define	L_tmpnam	1024	/* XXX must be == PATH_MAX */
#define	TMP_MAX		308915776	/* Minimum number of unique filenames generated by tmpnam().
						 	   Maximum number of times an application can call tmpnam() reliably.
						       The value of {TMP_MAX} is at least 25. */

#define	__SLBF	0x0001		/* line buffered */
#define	__SNBF	0x0002		/* unbuffered */
#define	__SRD	0x0004		/* OK to read */
#define	__SWR	0x0008		/* OK to write */
	/* RD and WR are never simultaneously asserted */
#define	__SRW	0x0010		/* open for reading & writing */
#define	__SEOF	0x0020		/* found EOF */
#define	__SERR	0x0040		/* found error */
#define	__SMBF	0x0080		/* _buf is from malloc */
#define	__SAPP	0x0100		/* fdopen()ed in append mode */
#define	__SSTR	0x0200		/* this is an sprintf/snprintf string */
#define	__SOPT	0x0400		/* do fseek() optimization */
#define	__SNPT	0x0800		/* do not do fseek() optimization */
#define	__SOFF	0x1000		/* set iff _offset is in fact correct */
#define	__SMOD	0x2000		/* true => fgetln modified _p text */


/* stdio buffers */
struct __sbuf {
	unsigned char *_base;
	int	_size;
};

typedef unsigned int fpos_t;

typedef	struct __sFILE {
	unsigned char	*_p;		/* current position in (some) buffer */
	int				_r;			/* read space left for getc() */
	int				_w;			/* write space left for putc() */
	short			_flags;		/* flags, below; this FILE is free if 0 */
	short			_file;		/* fileno, if Unix descriptor, else -1 */
	struct	__sbuf	_bf;		/* the buffer (at least 1 byte, if !NULL) */
	int				_lbfsize;	/* 0 or -_bf._size, for inline putc */

	/* operations */
	void			*_cookie;	/* cookie passed to io functions */
	int	(*_close) __P((void *));
	int	(*_read)  __P((void *, char *, int));
	fpos_t	(*_seek)  __P((void *, fpos_t, int));
	int	(*_write) __P((void *, const char *, int));

	/* separate buffer for long sequences of ungetc() */
	struct	__sbuf	_ub;		/* ungetc buffer */
	unsigned char	*_up;		/* saved _p when _p is doing ungetc data */
	int				_ur;		/* saved _r when _r is counting ungetc data */

	/* tricks to meet minimum requirements even when malloc() fails */
	unsigned char	_ubuf[3];	/* guarantee an ungetc() buffer */
	unsigned char	_nbuf[1];	/* guarantee a getc() buffer */

	/* separate buffer for fgetln() when line crosses buffer boundary */
	struct __sbuf	_lb;		/* buffer for fgetln() */

	/* Unix stdio files get aligned to block boundaries on fseek() */
	int				_blksize;	/* stat.st_blksize (may be != _bf._size) */
	fpos_t			_offset;	/* current lseek offset (see WARNING) */
} FILE;


extern FILE __sF[];
extern const char *const sys_errlist[];
extern const int sys_nerr;


#define	stdin	(&__sF[0])
#define	stdout	(&__sF[1])
#define	stderr	(&__sF[2])

#define	__sfeof(p)	(((p)->_flags & __SEOF) != 0)
#define	__sferror(p)	(((p)->_flags & __SERR) != 0)
#define	__sclearerr(p)	((void)((p)->_flags &= ~(__SERR|__SEOF)))
int	__srget __P((FILE *));
#define	__sgetc(p) (--(p)->_r < 0 ? __srget(p) : (int)(*(p)->_p++))
#define	__sfileno(p)	((p)->_file)

#define	 vfscanf	__svfscanf
#define	P_tmpdir	"/var/tmp/"

int	__swbuf(int, FILE *);
static __inline int __sputc(int _c, FILE *_p)
{
	if (--_p->_w >= 0 || (_p->_w >= _p->_lbfsize && (char)_c != '\n'))
		return (*_p->_p++ = _c);
	else
		return (__swbuf(_c, _p));
}

/* Function declarations. */
extern void		 clearerr(FILE *);
extern char		*ctermid(char *);
extern int		 fclose(FILE *);
extern FILE		*fdopen(int,const char*);
extern int		 feof(FILE *);
extern int		 ferror(FILE *);
extern int		 fflush(FILE *);
extern int		 fgetc(FILE *);
extern int		 fgetpos(FILE *, fpos_t *);
extern char		*fgets(char *,int,FILE*);
extern int		 fileno(FILE *stream);
extern FILE		*fopen(const char *, const char *);
extern int		 fprintf(FILE *, const char *, ...);
extern int		 fputc(int, FILE *);
extern int		 fputs(const char *, FILE *);
extern size_t	 fread(void *, size_t, size_t, FILE *);
extern FILE		*freopen(const char *, const char *,FILE *);
extern int		 fscanf(FILE *, const char *, ...);
extern int		 fseek(FILE *, long, int);
extern int		 fsetpos(FILE *,const fpos_t *);
extern long		 ftell(FILE *);
extern size_t    fwrite(const void *, size_t, size_t, FILE *);
extern int		 getc(FILE *);
extern int		 getchar(void);
extern char		*gets(char *);
extern void		 perror(const char *);
extern int		 printf(const char *, ...);
extern FILE		*popen(const char *command, const char *mode);
extern int		 pclose(FILE *stream);
extern int		 putc(int, FILE *);
extern int		 putchar(int);
extern int		 puts(const char *);
extern int		 rename(const char *, const char *);
extern int		 remove(const char *);
extern void		 rewind(FILE *);
extern int		 scanf(const char *, ...);
extern void		 setbuf(FILE *, char *);
extern int		 setvbuf(FILE *, char *, int, size_t);
extern int		 snprintf(char *s, size_t n,const char *format, ...);
extern int		 sprintf(char *, const char *, ...);
extern int		 sscanf(const char *, const char *, ...);
extern FILE		*tmpfile(void);
extern char		*tmpnam(char *s);
extern int		 ungetc(int, FILE *);
extern int		 vfprintf(FILE *, const char *, va_list);
extern int		 vprintf(const char *, va_list);
extern int		 vasprintf(char **, const char *, va_list);
extern int		 vsprintf(char *, const char *, va_list);
extern int		 vsnprintf(char *, size_t, const char *, va_list);
extern FILE		*funopen(const void *,int (*)(void *, char *, int),int (*)(void *, const char *, int), fpos_t (*)(void *, fpos_t, int),int (*)(void *));
extern int		 __svfscanf (FILE *, const char *, va_list);
extern int		 setlinebuf(FILE *);
extern int		 vsscanf (const char *, const char *, va_list);
extern char		*fgetln (FILE *, size_t *);
extern void		 setbuffer(FILE *, char *, int);
extern int		 asprintf(char **str, char const *fmt, ...);
extern char		*tempnam __P((const char *, const char *));

/* ̤ */
extern char    *tmpname(char *);


#endif
