/*
 * crt0.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/config.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>


char **environ;
char *__progname = "\0";

extern void initSbrk(const uint);
extern int main(int argc, char **argv, char **envp);

void _start(
	int argc,
	char *argv[],
	char **envp)
{
	SYS_INFO *sys_info = (SYS_INFO*) SYS_INFO_ADDR;

	initSbrk(sys_info->lastAddr);

	environ = envp;

	// ץ̾
	if (argv[0]) {
		if ((__progname = strrchr(argv[0], '/')) == NULL) {
			__progname = argv[0];
		}
		else {
			++__progname;
		}
	}

	exit(main(argc, argv, envp));
}
