/*
 * gethostname.c
 */


#include<sys/types.h>
#include<string.h>
#include<sys/utsname.h>


int gethostname(char *name, size_t namelen)
{
	int len;
	struct utsname utsname;


	if(uname(&utsname)==-1)return -1;
	len=(namelen>=UTSNAME_STR_SIZE)?UTSNAME_STR_SIZE:namelen;
	memcpy(name,utsname.nodename,len-1);
	name[len-1]='\0';

	return 0;
}
