/*
 * sysconf.c
 */


#include<sys/config.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<errno.h>
#include<signal.h>
#include<stdio.h>
#include<stropts.h>
#include<unistd.h>


long sysconf(int name)
{
	switch(name)
	{
		case _SC_ARG_MAX:
			return ARG_MAX;
		case _SC_CHILD_MAX:
			return CHILD_MAX;
		case _SC_OPEN_MAX:
			return OPEN_MAX;
		case _SC_STREAM_MAX:
			return STREAM_MAX;
		case _SC_TZNAME_MAX:
			return TZNAME_MAX;
		case _SC_JOB_CONTROL:
			return _POSIX_JOB_CONTROL;
		case _SC_SAVED_IDS:
			return _POSIX_SAVED_IDS;
		case _SC_VERSION:
			return _POSIX_VERSION;
		case _SC_CLK_TCK:
			return 1000000;
		case _SC_2_C_BIND:
		case _SC_2_C_DEV:
		case _SC_2_C_VERSION:
		case _SC_2_CHAR_TERM:
		case _SC_2_FORT_DEV:
		case _SC_2_FORT_RUN:
		case _SC_2_LOCALEDEF:
		case _SC_2_PBS:
		case _SC_2_PBS_ACCOUNTING:
		case _SC_2_PBS_CHECKPOINT:
		case _SC_2_PBS_LOCATE:
		case _SC_2_PBS_MESSAGE:
		case _SC_2_PBS_TRACK:
		case _SC_2_SW_DEV:
		case _SC_2_UPE:
		case _SC_2_VERSION:
		case _SC_ADVISORY_INFO:
		case _SC_AIO_LISTIO_MAX:
		case _SC_AIO_MAX:
		case _SC_AIO_PRIO_DELTA_MAX:
		case _SC_ASYNCHRONOUS_IO:
		case _SC_BC_BASE_MAX:
		case _SC_BC_DIM_MAX:
		case _SC_BC_SCALE_MAX:
		case _SC_BC_STRING_MAX:
		case _SC_COLL_WEIGHTS_MAX:
		case _SC_CPUTIME:
		case _SC_DELAYTIMER_MAX:
		case _SC_EXPR_NEST_MAX:
		case _SC_FILE_LOCKING:
		case _SC_FSYNC:
		case _SC_GETGR_R_SIZE_MAX:
		case _SC_GETPW_R_SIZE_MAX:
		case _SC_HOST_NAME_MAX:
		case _SC_LINE_MAX:
		case _SC_LOGIN_NAME_MAX:
		case _SC_MAPPED_FILES:
		case _SC_MEMLOCK:
		case _SC_MEMLOCK_RANGE:
		case _SC_MEMORY_PROTECTION:
		case _SC_MESSAGE_PASSING:
		case _SC_MQ_OPEN_MAX:
		case _SC_MQ_PRIO_MAX:
		case _SC_NGROUPS_MAX:
		case _SC_PRIORITIZED_IO:
		case _SC_PRIORITY_SCHEDULING:
		case _SC_RE_DUP_MAX:
		case _SC_REALTIME_SIGNALS:
		case _SC_REGEXP:
		case _SC_RTSIG_MAX:
		case _SC_SEMAPHORES:
		case _SC_SEM_NSEMS_MAX:
		case _SC_SEM_VALUE_MAX:
		case _SC_SHARED_MEMORY_OBJECTS:
		case _SC_SHELL:
		case _SC_SIGQUEUE_MAX:
		case _SC_SPAWN:
		case _SC_SPORADIC_SERVER:
		case _SC_SYNCHRONIZED_IO:
		case _SC_THREAD_ATTR_STACKADDR:
		case _SC_THREAD_ATTR_STACKSIZE:
		case _SC_THREAD_CPUTIME:
		case _SC_THREAD_DESTRUCTOR_ITERATIONS:
		case _SC_THREAD_KEYS_MAX:
		case _SC_THREAD_PRIO_INHERIT:
		case _SC_THREAD_PRIO_PROTECT:
		case _SC_THREAD_PRIORITY_SCHEDULING:
		case _SC_THREAD_PROCESS_SHARED:
		case _SC_THREAD_SAFE_FUNCTIONS:
		case _SC_THREAD_SPORADIC_SERVER:
		case _SC_THREAD_STACK_MIN:
		case _SC_THREAD_THREADS_MAX:
		case _SC_TIMEOUTS:
		case _SC_THREADS:
		case _SC_TIMER_MAX:
		case _SC_TIMERS:
		case _SC_TTY_NAME_MAX:
		case _SC_V6_ILP32_OFF32:
		case _SC_V6_ILP32_OFFBIG:
		case _SC_V6_LP64_OFF64:
		case _SC_V6_LPBIG_OFFBIG:
			return 0;
		default:
			return _error(EINVAL);
	}
}
