/*	$NetBSD: bus.h,v 1.12 1997/10/01 08:25:15 fvdl Exp $	*/

/*-
 * Copyright (c) 1996, 1997 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe of the Numerical Aerospace Simulation Facility,
 * NASA Ames Research Center.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Copyright (c) 1996 Charles M. Hannum.  All rights reserved.
 * Copyright (c) 1996 Christopher G. Demetriou.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Christopher G. Demetriou
 *	for the NetBSD Project.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/i386/include/bus_at386.h,v 1.8.2.4 2003/08/09 16:21:19 luoqi Exp $
 *
 * 2008: modified by minoru murashima.
 */

#ifndef _I386_BUS_AT386_H_
#define _I386_BUS_AT386_H_

#include <sys/types.h>
#include <i386/io.h>

/*
 * Values for the i386 bus space tag, not to be used directly by MI code.
 */
#define	I386_BUS_SPACE_IO	0	/* space is i/o space */
#define I386_BUS_SPACE_MEM	1	/* space is mem space */

/*
 * Access methods for bus resources and address space.
 */
typedef	int bus_space_tag_t;
typedef	u_int bus_space_handle_t;
typedef u_int32_t bus_size_t;
#ifdef PAE
typedef u_int64_t bus_addr_t;
#else
typedef u_int32_t bus_addr_t;
#endif

static inline u_int8_t bus_space_read_1(
	bus_space_tag_t tag, 
	bus_space_handle_t handle,
	bus_size_t offset)
{
	if (tag == I386_BUS_SPACE_IO) {
		return (inb(handle + offset));
	}
	return (*(volatile u_int8_t *) (handle + offset));
}

static inline u_int16_t bus_space_read_2(
	bus_space_tag_t tag, 
	bus_space_handle_t handle,
	bus_size_t offset)
{
	if (tag == I386_BUS_SPACE_IO) {
		return (inw(handle + offset));
	}
	return (*(volatile u_int16_t *) (handle + offset));
}

static inline u_int32_t bus_space_read_4(
	bus_space_tag_t tag, 
	bus_space_handle_t handle,
	bus_size_t offset)
{
	if (tag == I386_BUS_SPACE_IO) {
		return (inl(handle + offset));
	}
	return (*(volatile u_int32_t *) (handle + offset));
}

static inline void bus_space_write_1(
	bus_space_tag_t tag, 
	bus_space_handle_t bsh,
	bus_size_t offset, 
	u_int8_t value)
{
	if (tag == I386_BUS_SPACE_IO) {
		outb(bsh + offset, value);
	}
	else {
		*(volatile u_int8_t *)(bsh + offset) = value;
	}
}

static inline void bus_space_write_2(
	bus_space_tag_t tag, 
	bus_space_handle_t bsh,
	bus_size_t offset, 
	u_int16_t value)
{
	if (tag == I386_BUS_SPACE_IO) {
		outw(bsh + offset, value);
	}
	else {
		*(volatile u_int16_t *)(bsh + offset) = value;
	}
}

static inline void bus_space_write_4(
	bus_space_tag_t tag, 
	bus_space_handle_t bsh,
	bus_size_t offset, 
	u_int32_t value)
{
	if (tag == I386_BUS_SPACE_IO) {
		outl(bsh + offset, value);
	}
	else {
		*(volatile u_int32_t *)(bsh + offset) = value;
	}
}

#endif /* _I386_BUS_AT386_H_ */
