/*
 * ⥸塼ᥤ
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/module.h>
#include <sys/bus.h>
#include <stdio.h>
#include <lib/dev_method.h>
#include <machine/resource.h>
#include <isa/isa_common.h>
#include <isa/isavar.h>
#include <isa/isareg.h>
#include <kbd/atkbdcreg.h>
#include <kbd/kbdreg.h>

extern struct sysinit rootbusmodule_sys_init;
extern moduledata_t nexus_root_mod;
extern moduledata_t isa_nexus_mod;
extern moduledata_t atkbdc_isa_mod;
extern moduledata_t atkbd_atkbdc_mod;
extern void root_bus_configure();

/*
 * 饹̾ȥ˥åȤǥХ
 * return : device_t or NULL
 */
static device_t getDevice(
	const char *name,
	const int unit)
{
	devclass_t class;
	device_t dev;

	class  = devclass_find(name);
	if (class == NULL) {
		printf("Find devclass error!\n");
		return NULL;
	}

	dev = devclass_get_device(class, unit);
	if (dev == NULL) {
		printf("Find device error!\n");
		return NULL;
	}

	return dev;
}

int main()
{
	device_t rootDev;
	device_t isaDev;
	device_t atkbdcDev;
	int error;

	// ⥸塼
	if (initModule() != 0) {
		printf("initModue failed!\n");
		return 0;
	}

	// ɥ饤С⥸塼
	module_init();

	// 롼ȥХ
	rootbusmodule_sys_init.func(rootbusmodule_sys_init.udata);

	// NEXUSɥ饤С
	module_register_init(&nexus_root_mod);
	
	// ISAɥ饤С
	module_register_init(&isa_nexus_mod);
	
	// ATKBDCɥ饤С
	module_register_init(&atkbdc_isa_mod);
	
	// ATKBDɥ饤С
	module_register_init(&atkbd_atkbdc_mod);
	
	// NEXUSǥХϿ
	rootDev = getDevice("root", 0);
	if (rootDev == NULL) {
		return 0;
	}
	device_add_child(rootDev, "nexus", 0);

	// ХͭISAХޤͭ
	root_bus_configure();

	// ATKBDCǥХϿ
	isaDev = getDevice("isa", 0);
	if (isaDev == NULL) {
		return 0;
	}
	atkbdcDev = BUS_ADD_CHILD(isaDev, 0, "atkbdc", 0);
	if (atkbdcDev == NULL) {
		return 0;
	}

	// ATKBDC꥽ȥ꡼Ͽ
	{
		struct isa_device* idev = DEVTOISA(atkbdcDev);
		resource_list_add(&idev->id_resources, SYS_RES_IOPORT, 0, IO_KBD + KBD_DATA_PORT, ~0, 1);
		resource_list_add(&idev->id_resources, SYS_RES_IOPORT, 1, IO_KBD + KBD_STATUS_PORT, ~0, 1);
	}
	isa_probe_children(isaDev);

//	kbd_configure(0);

	// ⥸塼Ͽ
	if (registModule("keybord.mod") != 0) {
		printf("registModule failed!\n");
		return 0;
	}

	// ꡼
	error = sleepModule(getReturnMethod());
	if (error != 0) {
		printf("Module sleep error! : %d\n", errno);
	}

	// ̥ץޤäƤʤ

	// ATKBDɥ饤Сκ
	{
		module_t mod = module_lookupbyname(atkbd_atkbdc_mod.name);
		if (mod != NULL) {
			module_unload(mod);
		}
	}

	// ATKBDCɥ饤Сκ
	{
		module_t mod = module_lookupbyname(atkbdc_isa_mod.name);
		if (mod != NULL) {
			module_unload(mod);
		}
	}

	printf("Module was deleted\n");

	
	return 0;
}
