/*
 * ioconf.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסISAǥХ꥽
 */

#include <sys/bus_private.h>
#include <isa/isareg.h>

//================================== PRIVATE ============================================

//===================================== PUBLIC =====================================================

// ǥХ꥽ϡɥǥ
struct config_resource atkbdcResource[] = {
	{"at"		, RES_STRING	, {(long) "isa0"}},
	{"ioport"	, RES_INT		, {IO_KBD}},
};

struct config_resource atkbdResource[] = {
	{"at"		, RES_STRING	, {(long) "atkbdc0"}},
	{"irq"		, RES_INT		, {1}},
	{"flags"	, RES_INT		, {0x1}},
};

struct config_resource fdcResource[] = {
	{"at"		, RES_STRING	, {(long) "isa0"}},
	{"ioport"	, RES_INT		, {IO_FD1}},
	{"irq"		, RES_INT		, {6}},
	{"drq"		, RES_INT		, {2}},
};

struct config_resource fdResource[] = {
	{"at"		, RES_STRING	, {(long) "fdc0"}},
};

struct config_device devtab[] = {
	{"atkbdc"	, 0, 2, atkbdcResource},
	{"atkbd"	, 0, 3, atkbdResource},
	{"fdc"		, 0, 4, fdcResource},
	{"fd"		, 0, 1, fdResource},
};

int devtab_count = 4;
