/*
 * Copyright (c) 1997,1998 Doug Rabson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/kern/subr_bus.c,v 1.54.2.9 2002/10/10 15:13:32 jhb Exp $
 *
 * 2008: modified by minoru murashima.
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/bus.h>
#include <sys/bus_private.h>
#include <sys/module.h>
#include <lib/dev_method.h>


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static device_t	root_bus;

static int root_print_child(
	device_t dev, 
	device_t child)
{
	return (0);
}

static int root_setup_intr(
	device_t dev, 
	device_t child, 
	driver_intr_t *intr, 
	void *arg,
	void **cookiep)
{
	/*
	 * If an interrupt mapping gets to here something bad has happened.
	 */
	panic("root_setup_intr");
}

static device_method_t root_methods[] = {
	/* Device interface */
	DEVMETHOD(device_shutdown,	bus_generic_shutdown),
	DEVMETHOD(device_suspend,	bus_generic_suspend),
	DEVMETHOD(device_resume,	bus_generic_resume),

	/* Bus interface */
	DEVMETHOD(bus_print_child,	root_print_child),
	DEVMETHOD(bus_read_ivar,	bus_generic_read_ivar),
	DEVMETHOD(bus_write_ivar,	bus_generic_write_ivar),
	DEVMETHOD(bus_setup_intr,	root_setup_intr),

	{ 0, 0 }
};

static driver_t root_driver = {
	"root",
	root_methods,
	1,			/* no softc */
};

static int root_bus_module_handler(
	module_t mod, 
	int what, 
	void* arg)
{
	switch (what) {
	case MOD_LOAD:
		compile_methods(&root_driver);
		root_bus = make_device(NULL, "root", 0);
		root_bus->desc = "System root bus";
		root_bus->ops = root_driver.ops;
		root_bus->driver = &root_driver;
		root_bus->state = DS_ATTACHED;
		root_devclass = devclass_find_internal("root", FALSE);
		return 0;

	case MOD_SHUTDOWN:
		device_shutdown(root_bus);
		return 0;
	}

	return 0;
}

static moduledata_t root_bus_mod = {
	"rootbus",
	root_bus_module_handler,
	0
};

//===================================== PUBLIC =====================================================

devclass_t	root_devclass;

DECLARE_MODULE(rootbus, root_bus_mod, SI_SUB_DRIVERS, SI_ORDER_FIRST);
//	struct sysinit rootbusmodule_sys_init = { 
//		SI_SUB_DRIVERS, 
//		SI_ORDER_FIRST, 
//		(sysinit_cfunc_t)(sysinit_nfunc_t)module_register_init, 
//		(void *)&root_bus_mod 
//	}; 

void root_bus_configure(void)
{
	device_t dev;

	for (dev = TAILQ_FIRST(&root_bus->children); dev; dev = TAILQ_NEXT(dev, link)) {
		device_probe_and_attach(dev);
	}
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------
