/*
 * pthread_create.c
 *
 * Test pthread_create.
 */

#include <sys/config.h>
#include <sys/param.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <limits.h>
#include <pthread.h>

static char *alloc1;
static char *alloc2;

static void do_alloc(void *arg)
{
	// Allocate1
	if (alloc1 != NULL) {
		if (alloc1[PAGE_DIR_SIZE - 1] != 'a') {
			printf("Allocate1 error : %x\n", alloc1[PAGE_DIR_SIZE - 1]);
		}
	}
	else {
		printf("Allocate1 Not allocate!\n");
	}

	// Allocate2
	alloc2 = malloc(PAGE_DIR_SIZE);
	if (alloc2 == NULL) {
		perror("Allocate2 malloc"); 
		exit(1);
	}
	alloc2[PAGE_DIR_SIZE - 1] = 'b';
}

int main(void)
{
	pthread_t thread;
	void *value;

	if (pthread_create(&thread, NULL, (void*) do_alloc, NULL) != 0) {
		perror("pthread_create"); 
		exit(1);
	}

	// Allocate1
	alloc1 = malloc(PAGE_DIR_SIZE);
	if (alloc1 == NULL) {
		perror("Allocate1 malloc"); 
		exit(1);
	}
	alloc1[PAGE_DIR_SIZE - 1] = 'a';

	if (pthread_join(thread, &value) != 0) {
		perror("pthread_join"); 
		exit(1);
	}
	
	printf("testThread OK\n");

	return 0;
}
