/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.ssuif.swt;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;
import jp.gr.java_conf.dev240k.util.ssuif.SsuifUtil;
import jp.gr.java_conf.dev240k.util.ssuif.swt.ControlBuilderFactory;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlBuilder;
import jp.gr.java_conf.dev240k.util.ssuif.swt.IControlFactory;

class PropertiesLoader {
    private static final String KEY_MODEL_PACKAGE = "model.package";
    private static final String KEY_BUILDER_PACKAGE = "builder.package";
    private static final String KEY_CONTROL_FACTORY = "control.factory";
    private static final String KEY_CONTROL_BUILDER = "control.builder.";
    private static final int KEY_CONTROL_BUILDER_INDEX = "control.builder.".length();

    PropertiesLoader() {
    }

    void load(ResourceBundle rb, ControlBuilderFactory factory, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Enumeration<String> em = rb.getKeys();
        boolean isTraceEnabled = LoggerUtil.isTraceEnabled(this.getClass());
        String modelPackage = null;
        try {
            modelPackage = rb.getString(KEY_MODEL_PACKAGE);
            if (isTraceEnabled) {
                String[] args = new String[]{modelPackage};
                LoggerUtil.trace(this.getClass(), (String)SsuifUtil.getMessage((String)"message.trace.ModelPackage", (String[])args));
            }
            modelPackage = String.valueOf(modelPackage) + ".";
        }
        catch (MissingResourceException missingResourceException) {}
        String builderPackage = null;
        try {
            builderPackage = rb.getString(KEY_BUILDER_PACKAGE);
            if (isTraceEnabled) {
                String[] args = new String[]{builderPackage};
                LoggerUtil.trace(this.getClass(), (String)SsuifUtil.getMessage((String)"message.trace.BuilderPackage", (String[])args));
            }
            builderPackage = String.valueOf(builderPackage) + ".";
        }
        catch (MissingResourceException missingResourceException) {}
        while (em.hasMoreElements()) {
            String key = em.nextElement();
            if (KEY_CONTROL_FACTORY.equals(key)) {
                String controlFactoryName = rb.getString(key);
                if (isTraceEnabled) {
                    String[] args = new String[]{controlFactoryName};
                    LoggerUtil.trace(this.getClass(), (String)SsuifUtil.getMessage((String)"message.trace.ControlFactory", (String[])args));
                }
                IControlFactory controlFactory = (IControlFactory)classLoader.loadClass(controlFactoryName).newInstance();
                factory.setControlFactory(controlFactory);
                continue;
            }
            if (!key.startsWith(KEY_CONTROL_BUILDER)) continue;
            String modelName = key.substring(KEY_CONTROL_BUILDER_INDEX);
            if (modelPackage != null) {
                modelName = String.valueOf(modelPackage) + modelName;
            }
            String builderName = rb.getString(key);
            if (builderPackage != null) {
                builderName = String.valueOf(builderPackage) + builderName;
            }
            if (isTraceEnabled) {
                String[] args = new String[]{modelName, builderName};
                LoggerUtil.trace(this.getClass(), (String)SsuifUtil.getMessage((String)"message.trace.ControlBuilder", (String[])args));
            }
            Class<?> modelClass = classLoader.loadClass(modelName);
            IControlBuilder builder = (IControlBuilder)classLoader.loadClass(builderName).newInstance();
            factory.addControlBuilder(modelClass, builder);
        }
    }
}

