/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui;

import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.MixedCalcLibraryUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.CustomControlConfigurationElementWrapper;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcUIUtil;
import jp.gr.java_conf.dev240k.util.loader.ConfigurationElementWrapper;
import jp.gr.java_conf.dev240k.util.loader.ExtensionPointWrapper;
import jp.gr.java_conf.dev240k.util.loader.ExtensionWrapper;
import jp.gr.java_conf.dev240k.util.loader.InvalidExtensionConfigurationException;

public class CustomControlExtensionPointWrapper {
    private static final String STR_TAG_ID = "id";
    private ExtensionPointWrapper extensionPoint;

    public ExtensionPointWrapper getExtensionPoint() {
        return this.extensionPoint;
    }

    public CustomControlExtensionPointWrapper(ExtensionPointWrapper extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    private ConfigurationElementWrapper searchConfigurationFromExtension(ExtensionWrapper extension, String pluginId) throws InvalidExtensionConfigurationException {
        ConfigurationElementWrapper[] configs = extension.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            try {
                if (pluginId.equals(configs[i].getAttribute(STR_TAG_ID))) {
                    return configs[i];
                }
            }
            catch (InvalidExtensionConfigurationException e) {
                MixedCalcLoggerUtil.warn(this.getClass(), MixedCalcUIUtil.getMessage("message.error.InvalidPluginSettings"), e);
            }
            ++i;
        }
        return null;
    }

    public CustomControlConfigurationElementWrapper getConfigurationElement(String pluginId) {
        ExtensionWrapper[] extensions;
        try {
            extensions = this.extensionPoint.getExtensions();
        }
        catch (InvalidExtensionConfigurationException e) {
            MixedCalcLoggerUtil.warn(this.getClass(), MixedCalcLibraryUtil.getMessage((String)"message.error.InvalidPluginSettings"), e);
            return null;
        }
        int i = 0;
        while (i < extensions.length) {
            try {
                ConfigurationElementWrapper config = this.searchConfigurationFromExtension(extensions[i], pluginId);
                if (config != null) {
                    return new CustomControlConfigurationElementWrapper(config);
                }
            }
            catch (InvalidExtensionConfigurationException e) {
                MixedCalcLoggerUtil.warn(this.getClass(), MixedCalcLibraryUtil.getMessage((String)"message.error.InvalidPluginSettings"), e);
            }
            ++i;
        }
        return null;
    }
}

