/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.eclipse.actions;

import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitCategory;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.UnitSet;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class UnitObjectMoveUpwardAction
extends Action {
    ISelectionProvider selectionProvider = null;

    public UnitObjectMoveUpwardAction() {
    }

    public UnitObjectMoveUpwardAction(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    private void calculateEnabled(ISelection selection) {
        if (this.getSelectedObject(selection) != null) {
            super.setEnabled(true);
        } else {
            super.setEnabled(false);
        }
    }

    private void calculateEnabled() {
        if (this.selectionProvider == null) {
            super.setEnabled(false);
        }
        this.calculateEnabled(this.selectionProvider.getSelection());
    }

    public boolean isEnabled() {
        this.calculateEnabled();
        return super.isEnabled();
    }

    private Object getSelectedObject(ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (MixedCalcLoggerUtil.isTraceEnabled(((Object)((Object)this)).getClass())) {
            MixedCalcLoggerUtil.trace(((Object)((Object)this)).getClass(), firstElement.toString());
        }
        if (firstElement instanceof UnitCategory || firstElement instanceof Unit) {
            return firstElement;
        }
        return null;
    }

    private void moveUnitCategory(UnitCategory unitCategory) {
        UnitSet unitSet = unitCategory.getUnitSet();
        if (unitSet == null) {
            return;
        }
        int index = unitSet.indexOf(unitCategory);
        if (index <= 0) {
            return;
        }
        unitSet.removeUnitCategory(unitCategory);
        unitSet.addUnitCategory(--index, unitCategory);
    }

    private void moveUnit(Unit unit) {
        UnitCategory unitCategory = unit.getUnitCategory();
        if (unitCategory == null) {
            return;
        }
        int index = unitCategory.indexOf(unit);
        if (index <= 0) {
            return;
        }
        unitCategory.removeUnit(unit);
        unitCategory.addUnit(--index, unit);
    }

    public void run(ISelection selection) {
        Object selected = this.getSelectedObject(selection);
        if (selected instanceof UnitCategory) {
            this.moveUnitCategory((UnitCategory)selected);
        } else if (selected instanceof Unit) {
            this.moveUnit((Unit)selected);
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.setSelection(selection);
        }
    }

    public void run() {
        if (this.selectionProvider == null) {
            return;
        }
        this.run(this.selectionProvider.getSelection());
    }
}

