/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.pref;

import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.MixedCalcPreferenceManager;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcInnerException;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcUIUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.CompositeModel;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.pref.CompositeStatus;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.pref.CompositeStatusSet;
import org.apache.commons.betwixt.io.BeanReader;
import org.xml.sax.SAXException;

public class CompositeStatusManager {
    private static final String COMPOSITE_STATUS_FILENAME = "composite_status.xml";
    private BeanReader reader;
    private static final String DEFAULT_OPEN_AS = "default";
    private CompositeStatusSet compositeStatusSet;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private void initBeanReader() {
        this.reader = new BeanReader();
        this.reader.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        this.reader.getBindingConfiguration().setMapIDs(false);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.pref.CompositeStatusSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("statusSet", (Class)clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.pref.CompositeStatus");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("status", (Class)clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.CompositeModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("composite", (Class)clazz3);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.TabFolderModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("tabFolder", (Class)clazz4);
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.TabItemModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("tabItem", (Class)clazz5);
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.ControlModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.reader.registerBeanClass("control", (Class)clazz6);
        }
        catch (IntrospectionException e) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.fatal.InvalidInternalFile", args);
            MixedCalcLoggerUtil.fatal(this.getClass(), msg, e);
            throw new MixedCalcInnerException(msg, e);
        }
    }

    public CompositeStatusManager() {
        this.initBeanReader();
    }

    private InputStream getInternalStatusFileInputStream() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(COMPOSITE_STATUS_FILENAME);
        return is;
    }

    private boolean loadInternalCompositeStatus() {
        CompositeStatusSet compositeStatusSet;
        InputStream is = this.getInternalStatusFileInputStream();
        if (is == null) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.fatal.MissingInternalFile", args);
            MixedCalcLoggerUtil.fatal(this.getClass(), msg);
            throw new MixedCalcInnerException(msg);
        }
        if (MixedCalcLoggerUtil.isDebugEnabled(this.getClass())) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            MixedCalcLoggerUtil.debug(this.getClass(), MixedCalcUIUtil.getMessage("message.debug.ParsingInternalFile", args));
        }
        try {
            compositeStatusSet = (CompositeStatusSet)this.reader.parse(is);
        }
        catch (SAXException e) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.fatal.InvalidInternalFile", args);
            MixedCalcLoggerUtil.fatal(this.getClass(), msg, e);
            throw new MixedCalcInnerException(msg, e);
        }
        catch (IOException e) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.fatal.InvalidInternalFile", args);
            MixedCalcLoggerUtil.fatal(this.getClass(), msg, e);
            throw new MixedCalcInnerException(msg, e);
        }
        if (compositeStatusSet == null || compositeStatusSet.getCompositeStatusList().size() < 1) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.fatal.InvalidInternalFile", args);
            MixedCalcLoggerUtil.fatal(this.getClass(), msg);
            throw new MixedCalcInnerException(msg);
        }
        this.compositeStatusSet = compositeStatusSet;
        return true;
    }

    private InputStream getExternalStatusFileInputStream() {
        BufferedInputStream is;
        try {
            is = new BufferedInputStream(MixedCalcPreferenceManager.getFileInputStream((String)COMPOSITE_STATUS_FILENAME));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.info.FileNotExist", args);
            MixedCalcLoggerUtil.info(this.getClass(), msg);
            return null;
        }
        return is;
    }

    private boolean loadExternalCompositeStatus() {
        CompositeStatusSet compositeStatusSet;
        InputStream is = this.getExternalStatusFileInputStream();
        if (is == null) {
            return false;
        }
        if (MixedCalcLoggerUtil.isDebugEnabled(this.getClass())) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            MixedCalcLoggerUtil.debug(this.getClass(), MixedCalcUIUtil.getMessage("message.debug.ParsingFile", args));
        }
        try {
            compositeStatusSet = (CompositeStatusSet)this.reader.parse(is);
        }
        catch (SAXException e) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.error.InvalidPropertyFile", args);
            MixedCalcLoggerUtil.error(this.getClass(), msg, e);
            MixedCalcLoggerUtil.openErrorDialog(msg, e);
            return false;
        }
        catch (IOException e) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.error.InvalidPropertyFile", args);
            MixedCalcLoggerUtil.error(this.getClass(), msg, e);
            MixedCalcLoggerUtil.openErrorDialog(msg, e);
            return false;
        }
        if (compositeStatusSet == null || compositeStatusSet.getCompositeStatusList().size() < 1) {
            String[] args = new String[]{COMPOSITE_STATUS_FILENAME};
            String msg = MixedCalcUIUtil.getMessage("message.error.InvalidPropertyFile", args);
            MixedCalcLoggerUtil.error(this.getClass(), msg);
            MixedCalcLoggerUtil.openErrorDialog(msg);
            return false;
        }
        this.compositeStatusSet = compositeStatusSet;
        return true;
    }

    public void loadCompositeStatus() {
        if (!this.loadExternalCompositeStatus()) {
            this.loadInternalCompositeStatus();
        }
    }

    private CompositeModel getCompositeModelByOpenAs(String openAs) {
        if (openAs == null) {
            return null;
        }
        List compositeStatusList = this.compositeStatusSet.getCompositeStatusList();
        Iterator it = compositeStatusList.iterator();
        while (it.hasNext()) {
            CompositeStatus compositeStatus = (CompositeStatus)it.next();
            if (!openAs.equals(compositeStatus.getOpenAs())) continue;
            return compositeStatus.getComposite();
        }
        return null;
    }

    public CompositeModel getCompositeModel(String openAs) {
        CompositeModel compositeModel = this.getCompositeModelByOpenAs(openAs);
        if (compositeModel != null) {
            return compositeModel;
        }
        return this.getCompositeModelByOpenAs(DEFAULT_OPEN_AS);
    }
}

