/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.swt.builder.custom;

import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.Calculator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IElementModifyListener;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IDyadicOperator;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.BasicValueFormatter;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.BufferElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.NumberSystem;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import org.eclipse.swt.widgets.Label;

class SWTSimpleDisplayElementModifyListener
implements IElementModifyListener {
    Label numberSystemLabel;
    Label operatorLabel;
    Label elementLabel;
    Label unitLabel;

    SWTSimpleDisplayElementModifyListener() {
    }

    void setElementLabel(Label label) {
        this.elementLabel = label;
    }

    void setOperatorLabel(Label label) {
        this.operatorLabel = label;
    }

    void setNumberSystemLabel(Label label) {
        this.numberSystemLabel = label;
    }

    void setUnitLabel(Label label) {
        this.unitLabel = label;
    }

    private void setElementLabelText(IElement element) {
        String str;
        if (element instanceof BufferElement) {
            str = ((BufferElement)element).getBuffer().toString();
        } else if (element instanceof ValueElement) {
            BasicValueFormatter formatter = new BasicValueFormatter();
            str = formatter.format((ValueElement)element);
        } else {
            str = "null";
        }
        if (MixedCalcLoggerUtil.isTraceEnabled(this.getClass())) {
            MixedCalcLoggerUtil.trace(this.getClass(), "element label = " + str);
        }
        this.elementLabel.setText(str);
    }

    private void setOperatorLabelText(IDyadicOperator operator) {
        String str;
        if (operator != null) {
            str = operator.getMnemonic();
            if (str == null) {
                str = "";
            }
        } else {
            str = "";
        }
        if (MixedCalcLoggerUtil.isTraceEnabled(this.getClass())) {
            MixedCalcLoggerUtil.trace(this.getClass(), "operator label = " + str);
        }
        this.operatorLabel.setText(str);
    }

    private void setNumberSystemLabelText(IElement element) {
        int numSys = element instanceof BufferElement ? ((BufferElement)element).getNumberSystem() : (element instanceof ValueElement ? ((ValueElement)element).getNumberSystem() : 1);
        String strNumSys = NumberSystem.getShortName((int)numSys);
        if (MixedCalcLoggerUtil.isTraceEnabled(this.getClass())) {
            MixedCalcLoggerUtil.trace(this.getClass(), "number system label = " + strNumSys);
        }
        this.numberSystemLabel.setText(strNumSys);
    }

    private void setUnitLabelText(IElement element) {
        Unit unit = null;
        if (element instanceof BufferElement) {
            unit = ((BufferElement)element).getUnit();
        } else if (element instanceof ValueElement) {
            unit = ((ValueElement)element).getUnit();
        }
        String sign = "";
        if (unit != null && (sign = unit.getSign()) == null) {
            sign = "";
        }
        if (MixedCalcLoggerUtil.isTraceEnabled(this.getClass())) {
            MixedCalcLoggerUtil.trace(this.getClass(), "unit label = " + sign);
        }
        this.unitLabel.setText(sign);
    }

    public void modifyElement(Calculator calculator) {
        IElement element = calculator.getLastValue();
        if (MixedCalcLoggerUtil.isTraceEnabled(this.getClass())) {
            MixedCalcLoggerUtil.trace(this.getClass(), "element = " + element.toString());
        }
        this.setElementLabelText(element);
        this.setOperatorLabelText(calculator.getOperator());
        this.setNumberSystemLabelText(element);
        this.setUnitLabelText(element);
    }
}

