/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.IValueElement;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.unit.Unit;

public class ValueElement
implements IValueElement,
Cloneable {
    private static final String STR_NO_VALUE = "(no value)";
    List valueList = new ArrayList();
    private int numberSystem = 1;
    private Unit unit;

    public ValueElement() {
    }

    public ValueElement(double[] vals) {
        ArrayList<Double> valList = new ArrayList<Double>();
        int i = 0;
        while (i < vals.length) {
            valList.add(new Double(vals[i]));
            ++i;
        }
        this.setValueList(valList);
    }

    public List getValueList() {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        return this.valueList;
    }

    public void setValueList(List valueList) {
        this.valueList = valueList;
    }

    public int getNumberSystem() {
        return this.numberSystem;
    }

    public void setNumberSystem(int numberSystem) {
        this.numberSystem = numberSystem;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String toString() {
        if (this.valueList.isEmpty()) {
            return STR_NO_VALUE;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        Iterator it = this.valueList.iterator();
        while (it.hasNext()) {
            buffer.append(it.next().toString());
            buffer.append(" ");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(")");
        if (this.unit != null) {
            buffer.append(" ");
            buffer.append(this.unit.getSign());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj, double delta) {
        if (!(obj instanceof ValueElement)) {
            return false;
        }
        if (this.unit != ((ValueElement)obj).getUnit()) {
            return false;
        }
        List listObj = ((ValueElement)obj).getValueList();
        List listThis = this.valueList;
        if (listObj == null && listThis == null) {
            return true;
        }
        if (listObj == null) {
            return false;
        }
        if (listThis == null) {
            return false;
        }
        if (listObj.size() != listThis.size()) {
            return false;
        }
        Iterator itObj = listObj.iterator();
        Iterator itThis = listThis.iterator();
        while (itThis.hasNext()) {
            double dDelta;
            Double dObj;
            Double dThis = (Double)itThis.next();
            if (dThis.equals(dObj = (Double)itObj.next()) || !((dDelta = Math.abs(dThis) < Math.abs(dObj) ? Math.abs(dObj) * delta : Math.abs(dThis) * delta) < Math.abs(dThis - dObj))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, 0.0);
    }

    public int hashCode() {
        return this.valueList.hashCode();
    }

    public Object clone() {
        ValueElement ret = new ValueElement();
        ArrayList<Double> valList = new ArrayList<Double>();
        Iterator it = this.valueList.iterator();
        while (it.hasNext()) {
            valList.add(new Double((Double)it.next()));
        }
        ret.setValueList(valList);
        ret.setUnit(this.unit);
        return ret;
    }
}

