/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.commons;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public final class LoggerUtil {
    private static Map loggerMap = new HashMap();

    private LoggerUtil() {
    }

    public static void configure(ClassLoader loader, String fileName) {
        URL url = loader.getResource(fileName);
        if (fileName.endsWith("properties")) {
            PropertyConfigurator.configure((URL)url);
        } else {
            DOMConfigurator.configure((URL)url);
        }
    }

    private static Logger getLogger(Class clazz) {
        Logger logger = (Logger)loggerMap.get(clazz);
        if (logger == null) {
            logger = Logger.getLogger((Class)clazz);
            loggerMap.put(clazz, logger);
        }
        return logger;
    }

    public static boolean isTraceEnabled(Class clazz) {
        Logger logger = LoggerUtil.getLogger(clazz);
        return logger.isTraceEnabled();
    }

    public static void trace(Class clazz, String msg) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.trace((Object)msg);
    }

    public static boolean isDebugEnabled(Class clazz) {
        Logger logger = LoggerUtil.getLogger(clazz);
        return logger.isDebugEnabled();
    }

    public static void debug(Class clazz, String msg) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.debug((Object)msg);
    }

    public static boolean isInfoEnabled(Class clazz) {
        Logger logger = LoggerUtil.getLogger(clazz);
        return logger.isInfoEnabled();
    }

    public static void info(Class clazz, String msg) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.info((Object)msg);
    }

    public static void warn(Class clazz, String msg) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.warn((Object)msg);
    }

    public static void warn(Class clazz, String msg, Throwable e) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.warn((Object)msg, e);
    }

    public static void error(Class clazz, String msg) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.error((Object)msg);
    }

    public static void error(Class clazz, String msg, Throwable e) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.error((Object)msg, e);
    }

    public static void fatal(Class clazz, String msg) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.fatal((Object)msg);
    }

    public static void fatal(Class clazz, String msg, Throwable e) {
        Logger logger = LoggerUtil.getLogger(clazz);
        logger.fatal((Object)msg, e);
    }
}

