/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.dom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.gr.java_conf.dev240k.util.dom.NodeWrapper;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderWrapper {
    private static DocumentBuilderWrapper builderWrapper;

    protected DocumentBuilderWrapper() {
    }

    public static DocumentBuilderWrapper getInstance() {
        if (builderWrapper == null) {
            builderWrapper = new DocumentBuilderWrapper();
        }
        return builderWrapper;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new DefaultHandler());
        return documentBuilder;
    }

    public NodeWrapper parse(File file) throws SAXException, IOException, ParserConfigurationException {
        Document node = this.getDocumentBuilder().parse(file);
        return new NodeWrapper(node);
    }

    public NodeWrapper parse(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        Document node = this.getDocumentBuilder().parse(is);
        return new NodeWrapper(node);
    }

    private void transform(NodeWrapper node, StreamResult result) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        DOMSource source = new DOMSource(node.getNode());
        transformer.transform(source, result);
    }

    public void transform(NodeWrapper node, File file) throws TransformerFactoryConfigurationError, TransformerException {
        StreamResult result = new StreamResult(file);
        this.transform(node, result);
    }

    public void transform(NodeWrapper node, OutputStream os) throws TransformerFactoryConfigurationError, TransformerException {
        StreamResult result = new StreamResult(os);
        this.transform(node, result);
    }

    public NodeWrapper createDocumentNode() throws ParserConfigurationException {
        DOMImplementation domImpl = this.getDocumentBuilder().getDOMImplementation();
        Document document = domImpl.createDocument(null, null, null);
        return new NodeWrapper(document);
    }
}

