/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.loader;

import java.util.Iterator;
import java.util.List;
import jp.gr.java_conf.dev240k.util.dom.NodeWrapper;
import jp.gr.java_conf.dev240k.util.loader.ConfigurationElementWrapper;
import jp.gr.java_conf.dev240k.util.loader.InvalidExtensionConfigurationException;
import jp.gr.java_conf.dev240k.util.loader.PluginManagerUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class ExtensionWrapper {
    private static final String TAG_ID = "id";
    private IExtension extension = null;
    private ClassLoader classLoader = null;
    private NodeWrapper node = null;

    public ExtensionWrapper(IExtension extension) {
        this.extension = extension;
    }

    public ExtensionWrapper(ClassLoader classLoader, NodeWrapper node) {
        this.classLoader = classLoader;
        this.node = node;
    }

    public String getUniqueIdentifier() throws InvalidExtensionConfigurationException {
        if (this.extension != null) {
            try {
                return this.extension.getUniqueIdentifier();
            }
            catch (Exception e) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        }
        return this.node.getAttribute(TAG_ID);
    }

    public ConfigurationElementWrapper[] getConfigurationElements() throws InvalidExtensionConfigurationException {
        if (this.extension != null) {
            try {
                IConfigurationElement[] configurationElements = this.extension.getConfigurationElements();
                ConfigurationElementWrapper[] configurationWrappers = new ConfigurationElementWrapper[configurationElements.length];
                int i = 0;
                while (i < configurationElements.length) {
                    configurationWrappers[i] = new ConfigurationElementWrapper(configurationElements[i]);
                    ++i;
                }
                return configurationWrappers;
            }
            catch (Exception e) {
                throw new InvalidExtensionConfigurationException(PluginManagerUtil.getMessage("message.error.InvalidExtensionConfiguration"), e);
            }
        }
        List nodeList = this.node.getNodeList("*");
        ConfigurationElementWrapper[] configurationWrappers = new ConfigurationElementWrapper[nodeList.size()];
        Iterator it = nodeList.iterator();
        int i = 0;
        while (i < nodeList.size()) {
            configurationWrappers[i] = new ConfigurationElementWrapper(this.classLoader, (NodeWrapper)it.next());
            ++i;
        }
        return configurationWrappers;
    }
}

