<?php
	require("__include-common.php");
	require("__include-login.php");
	require("__include-account-check.php");

	$error_msg = "";
	if ($_POST) {
		$error_msg = post_done_proc();
	}

	html_header(HTML_TITLE, "_add_newaccount_confirm_header.php");
	page_header(False);
	input_form($error_msg);
	page_footer();
	html_footer();
	exit();
?>
<?php
// ********************************************************************
function input_form($error_msg) {
// ********************************************************************
	if ($error_msg == "OK") {
		finish_proc();
	} else {
		input_proc($error_msg);
	}
}
?>
<?php
// ********************************************************************
function finish_proc() {
// ********************************************************************
?>
<div class="input_form">
<h3>アカウント登録</h3>
<table>
<tr>
	<td>アカウント名：</td>
	<td><?= $_SESSION['newaccount_account'] ?></td>
</tr>
<tr>
	<td>ハンドル名：</td>
	<td><?= $_SESSION['newaccount_handle'] ?></td>
</tr>
<tr>
	<td>電子メールアドレス：</td>
	<td><?= $_SESSION['newaccount_email'] ?></td>
</tr>
<tr>
	<td>コメント：</td>
	<td><?= ins_br(my_htmlspecialchars($_SESSION['newaccount_msg'])) ?></td>
	</tr>
</table>
<p class="noramal_msg">ユーザーアカウントを登録しました。</p>
<p><input class="input_form_button" type="button" value="登録したユーザーアカウントでログインする" onClick="location.href='reset-to-login.php'"></p>
<?php
}
?>
<?php
// ********************************************************************
function input_proc($error_msg) {
// ********************************************************************
?>
<div class="input_form">
<h3>アカウント登録<a class="a_cancel_back" href="index.php">[キャンセル]</a></h3>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<table>
<tr>
	<td>アカウント名：</td>
	<td><?= $_SESSION['newaccount_account'] ?></td>
</tr>
<tr>
	<td>ハンドル名：</td>
	<td><?= $_SESSION['newaccount_handle'] ?></td>
</tr>
<tr>
	<td>電子メールアドレス：</td>
	<td><?= $_SESSION['newaccount_email'] ?></td>
</tr>
<tr>
	<td>コメント：</td>
	<td><?= ins_br(my_htmlspecialchars($_SESSION['newaccount_msg'])) ?></td>
</tr>
<tr>
	<td nowrap>認証用絵文字コード：<br><br>
	<img id="imgCaptcha" src="create_image.php" /><br>
	</td>
	<td nowrap>
	左の絵文字コードを下の入力欄に入れてください。<br>絵文字が見づらい場合は、絵文字変更ボタンを押してください。<br>
	<input class="text" type="text" name="captchastr" value="" size=20 style="ime-mode: disabled;">
	<input type="button" value="絵文字変更" onClick="location.reload()">
	</td>
</tr>
</table>
<p class="noramal_msg">上記内容で登録する場合は登録ボタンを押してください。</p>
<button class="input_form_button" onclick="inputCheckAll(); return false">登録</button>
<input class="input_form_button" type="button" value="戻る" onClick="location.href='newaccount.php'">
<input class="input_form_button" type="button" value="キャンセル" onClick="location.href='index.php'">
</form>
	<p class="error_msg"><?= $error_msg ?><p>
</div>
<?php
	return(0);
}
?>
<?php
function create_image_______XXXXXX() {
	//Let's generate a totally random string using md5 
	$md5_hash = md5(rand(0,999)); 
	//We don't need a 32 character long string so we trim it down to 5 
	$security_code = substr($md5_hash, 15, 5); 

	//Set the session to store the security code
	$_SESSION['security_code'] = $security_code;

	//Set the image width and height 
	$width = 100; 
	$height = 20;  

	//Create the image resource 
	$image = ImageCreate($width, $height);  

	//We are making three colors, white, black and gray 
	$white = ImageColorAllocate($image, 255, 255, 255); 
	$black = ImageColorAllocate($image, 0, 0, 0); 
	$grey = ImageColorAllocate($image, 204, 204, 204); 

	//Make the background black 
	ImageFill($image, 0, 0, $black); 

	//Add randomly generated string in white to the image

	//ImageString($image, 3, 30, 3, $security_code, $white); 
	ImageString($image, 3, 30, 3, "ab12DEF", $white); 

	//Throw in some lines to make it a little bit harder for any bots to break 
	ImageRectangle($image,0,0,$width-1,$height-1,$grey); 
	imageline($image, 0, $height/2-3, $width, $height/2-3, $grey); 
	imageline($image, 0, $height/2+3, $width, $height/2+3, $grey); 
	imageline($image, $width/2+10, 0, $width/2+10, $height, $grey); 

	//Tell the browser what kind of file is come in 
	header("Content-Type: image/jpeg"); 

	//Output the newly created image in jpeg format 
	ImageJpeg($image); 
	
	//Free up resources
	ImageDestroy($image); 
}
function create_image_original_______XXXXXX() {
	//Let's generate a totally random string using md5 
	$md5_hash = md5(rand(0,999)); 
	//We don't need a 32 character long string so we trim it down to 5 
	$security_code = substr($md5_hash, 15, 5); 

	//Set the session to store the security code
	$_SESSION['security_code'] = $security_code;

	//Set the image width and height 
	$width = 100; 
	$height = 20;  

	//Create the image resource 
	$image = ImageCreate($width, $height);  

	//We are making three colors, white, black and gray 
	$white = ImageColorAllocate($image, 255, 255, 255); 
	$black = ImageColorAllocate($image, 0, 0, 0); 
	$grey = ImageColorAllocate($image, 204, 204, 204); 

	//Make the background black 
	ImageFill($image, 0, 0, $black); 

	//Add randomly generated string in white to the image

	//ImageString($image, 3, 30, 3, $security_code, $white); 
	ImageString($image, 3, 30, 3, "ab12DEF", $white); 

	//Throw in some lines to make it a little bit harder for any bots to break 
	ImageRectangle($image,0,0,$width-1,$height-1,$grey); 
	imageline($image, 0, $height/2-3, $width, $height/2-3, $grey); 
	imageline($image, 0, $height/2+3, $width, $height/2+3, $grey); 
	imageline($image, $width/2+10, 0, $width/2+10, $height, $grey); 

	//Tell the browser what kind of file is come in 
	header("Content-Type: image/jpeg"); 

	//Output the newly created image in jpeg format 
	ImageJpeg($image); 
	
	//Free up resources
	ImageDestroy($image);
}
?>
<?php
function post_done_proc() {
	$account = $_SESSION['newaccount_account'];
	$handle = $_SESSION['newaccount_handle'];
	$password = $_SESSION['newaccount_password'];
	$email = $_SESSION['newaccount_email'];
	$msg = $_SESSION['newaccount_msg'];

	if (($ret = ac_chk_account($account)) <> "") return ($ret);
	if (($ret = ac_chk_handle($handle)) <> "") return ($ret);
	if (($ret = ac_chk_password($password, $password)) <> "") return ($ret);
	if (($ret = ac_chk_email($email)) <> "") return ($ret);
	if (($ret = ac_chk_msg($msg)) <> "") return ($ret);

	if ($_POST['captchastr'] <> $_SESSION['security_code']) {
		return "認証用絵文字コードが違います。";
	}

	$con = my_mysql_connect(_DB_ACCOUNT_SCHEMA);
	$sql = "insert into m_account (";
	$sql .= "c_account, c_handle, c_email, c_password, c_msg, c_registtime";
	$sql .= ") values (";
	$sql .= "'". str_for_mysql($account) . "'";
	$sql .= ", '". str_for_mysql($handle) . "'";
	$sql .= ", '". str_for_mysql($email) . "'";
	$sql .= ", '". str_for_mysql($password) . "'";
	$sql .= ", '". str_for_mysql($msg) . "'";
	$sql .= ", '". date("Y/m/d H:i:s") . "'";
	$sql .= ")";
	$ret = my_mysql_query($sql);
	if (! $ret) {
		return "アカウントの登録に失敗しました。";
	}
	$con = mysql_close($con);
	return "OK";
}
?>
