<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("../__common__/include-common-mp-list.php");

	$table_name_view = "v_chokin";
	$table_name = "m_chokin";
	$id_item = "id_chokin";
	$must_item = "c_title";

	$mp_list_arg = array();
	$mp_list_arg['account_id']		= $_SESSION['current_id'];
	$mp_list_arg['table_name_view']		= "v_chokin";
	$mp_list_arg['table_name_edit']		= "v_chokin";
	$mp_list_arg['table_name_update']	= "m_chokin";
	$mp_list_arg['id_item']			= "id_chokin";
	$mp_list_arg['must_item']		= "c_kinyuShohin";
	$mp_list_arg['input_new']		= "no";
	$mp_list_arg['template_view']		= "list-my-template.php";
	$mp_list_arg['add_filter']		= "list-my-add-filter.php";
	$mp_list_arg['sql_create_callback']	= "my_mp_list_sql_create";
	$mp_list_arg['list_option_callback']	= "my_option_filter";
	$mp_list_arg['add_list']		= "yes";
	$mp_list_arg['filter_keysel_break']	= "yes";
	$mp_list_arg['view_description']	= "元金：月積の場合、月額x今日までの月数。";
	$mp_list_arg['view_description']	.= "満期日：<span class='chokin_manki_go'>日付</span>＝満期を過ぎている。<span class='chokin_manki_3go'>日付</span>＝満期まで3ヶ月。";
	$mp_list_arg['edit_description']	= "継続：継続＝満期時自動継続。解約＝満期時自動解約。解約済＝記録用、合計金額に足されません。";

	$item_tbl = array();
	$item_tbl[] = array(	"表示名"=>"金融機関",	"列名"=>"id_ginkou", "http_arg_GET名"=>"cat",
				"type"=>"select", "参照テーブル"=>"m_ginkou", "参照テーブル表示列"=>"c_ginkouName",
				"参照テーブル表示順"=>"c_ginkouDisplayOrder", "参照テーブル表示色"=>"c_ginkouDisplayColor");
	$item_tbl[] = array(	"表示名"=>"金融商品名",	"列名"=>"c_kinyuShohin",
				"type"=>"text", "size"=>30, "ime-mode"=>"active", "文字検索"=>"Y");
	$item_tbl[] = array(	"表示名"=>"名義",	"列名"=>"c_keiyakuSha",
				"type"=>"text", "size"=>8, "ime-mode"=>"active", "文字検索"=>"Y",
				"filter_use"=>"Y", "filter_c_delete"=>"no", "http_arg_GET名"=>"meigi",
				"参照テーブル"=>"v_keiyakuSha", "参照テーブル表示列"=>"c_keiyakuSha",
				"参照テーブル表示順"=>"c_keiyakuSha");
	$item_tbl[] = array(	"表示名"=>"預入額",	"列名"=>"c_keiyakuKin",
				"type"=>"text", "size"=>7, "ime-mode"=>"disabled");
	$item_tbl[] = array(	"表示名"=>"利率",	"列名"=>"c_ritsu",
				"type"=>"text", "size"=>4, "ime-mode"=>"disabled");
	$item_tbl[] = array(	"表示名"=>"種類",	"列名"=>"id_shurui", "http_arg_GET名"=>"shurui",
				"type"=>"select", "参照テーブル"=>"r_shurui", "参照テーブルユーザー"=>"共有", "filter_c_delete"=>"no", 
				"参照テーブル表示列"=>"c_shurui", "参照テーブル表示順"=>"id_shurui");
	$item_tbl[] = array(	"表示名"=>"継続",	"列名"=>"id_mankitype", "http_arg_GET名"=>"manki",
				"type"=>"select", "参照テーブル"=>"r_mankitype", "参照テーブルユーザー"=>"共有", "filter_c_delete"=>"no", 
				"参照テーブル表示列"=>"c_mankitype", "参照テーブル表示順"=>"id_mankitype");
	$item_tbl[] = array(	"表示名"=>"契約日",	"列名"=>"c_keiyakuYMD",
				"type"=>"date", "firstYear"=>1980, "toYear"=>10);
	$item_tbl[] = array(	"表示名"=>"満期日",	"列名"=>"c_mankiYMD",
				"type"=>"date", "firstYear"=>2000, "toYear"=>30);
	$order_tbl = array();
	$order_tbl[] = array(   "表示名"=>"最新順", "get_order_name"=>"new",
				"order_by"=>"id_chokin desc");		/* default */
	$order_tbl[] = array(   "表示名"=>"金融機関別", "get_order_name"=>"cat",
				"order_by"=>"c_ginkouDisplayOrder, id_ginkou, c_kinyuShohin");
	$order_tbl[] = array(   "表示名"=>"金融商品名別", "get_order_name"=>"kouza",
				"order_by"=>"c_kinyuShohin");
	$order_tbl[] = array(   "表示名"=>"名義別", "get_order_name"=>"meigi",
				"order_by"=>"c_keiyakuSha, c_ginkouDisplayOrder, id_ginkou, c_kinyuShohin");
	$order_tbl[] = array(   "表示名"=>"種類別", "get_order_name"=>"shurui",
				"order_by"=>"c_shurui, c_mankitype, c_ginkouDisplayOrder, id_ginkou, c_kinyuShohin");
	$order_tbl[] = array(   "表示名"=>"継続別", "get_order_name"=>"keizoku",
				"order_by"=>"c_mankitype, c_shurui, c_ginkouDisplayOrder, id_ginkou, c_kinyuShohin");
	$order_tbl[] = array(   "表示名"=>"契約日順", "get_order_name"=>"keiyaku",
				"order_by"=>"c_keiyakuYMD");
	$order_tbl[] = array(   "表示名"=>"満期日順", "get_order_name"=>"manki",
				"order_by"=>"c_mankiYMD");
	$http_arg = array();
	$http_arg['pl'] = PAGE_LINE_DEFAULT;		// mp_list 必須
	$http_arg['sort'] = '';				// mp_list 必須
	$http_arg['cat'] = '';				// mp_list 必須
	$http_arg['shurui'] = '';
	$http_arg['manki'] = '';
	$http_arg['meigi'] = '';
	$http_arg['key'] = '';				// mp_list 必須
	$http_arg['cid'] = '';

	if ($_GET['subt'].'' <> '') {
		$_SESSION['chokin_sub_total'] = $_GET['subt'];
	}
	if ($_GET['kaiyaku'].'' <> '') {
		$_SESSION['chokin_kaiyakuJotai'] = $_GET['kaiyaku'];
	}

	if (isset($_POST['登録'])) {
		check_post_account($_POST['login_id'], $_POST['current_id']);
		mp_list_update($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
	} else {
		_GET_to_http_arg_pool($http_arg, $table_name, 'sort,key,pl');
		html_header(HTML_TITLE);
//		page_header();
		page_header_return_index();
		contents_header();
		if ($_GET['edit'] == "a") {
			$mp_list_arg['sql_create_callback'] = "";
			$mp_list_arg['sql_for_edit'] = "select * from v_chokin where id_chokin = 0";
			mp_list_edit($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
		} elseif ($_GET['edit'] == "y") {
			mp_list_edit($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
		} else {
			mp_list_view($mp_list_arg, $item_tbl, $order_tbl, $http_arg);
		}
		page_footer();
		html_footer();
	}
	exit();


// ****************************************************************
function my_option_filter($http_arg) {
// ****************************************************************
?>
<script language="JavaScript">
<!--
function CheckboxSubTotal(onOff) {
	if (onOff == 'on') {
		window.location.href = "?subt=off&<?= query_from_http_arg_pool($http_arg) ?>";
	} else {
		window.location.href = "?subt=on&<?= query_from_http_arg_pool($http_arg) ?>";
	}
}
function CheckboxKaiyaku(onOff) {
	if (onOff == 'on') {
		window.location.href = "?kaiyaku=off&<?= query_from_http_arg_pool($http_arg) ?>";
	} else {
		window.location.href = "?kaiyaku=on&<?= query_from_http_arg_pool($http_arg) ?>";
	}
}
//-->
</script>
<?php
?>
	<input type="checkbox" name="" value="on" onClick="CheckboxSubTotal('<?= $_SESSION['chokin_sub_total'] ?>')"<?= $_SESSION['chokin_sub_total'] == 'on' ? ' checked' : '' ?>>小計を計算
	<input type="checkbox" name="" value="on" onClick="CheckboxKaiyaku('<?= $_SESSION['chokin_kaiyakuJotai'] ?>')"<?= $_SESSION['chokin_kaiyakuJotai'] == 'on' ? ' checked' : '' ?>>解約状態
<?php
}
// ****************************************************************
function my_mp_list_sql_create($account_id, $table_name, $item_tbl, $order_tbl, $sortorder, $keystring, $sel_filter, $use_privacy, $add_where="") {
// ****************************************************************
	$sql = "SELECT v_chokin.* ";
	$sql .= ", (YEAR(current_date)-YEAR(c_keiyakuYMD))*12 + MONTH(current_date)-MONTH(c_keiyakuYMD) - (DAY(current_date)+1<DAY(c_keiyakuYMD)) as todayKeikaMonth";
	$sql .= ", (YEAR(c_mankiYMD)-YEAR(c_keiyakuYMD))*12 + MONTH(c_mankiYMD)-MONTH(c_keiyakuYMD) - (DAY(c_mankiYMD)+1<DAY(c_keiyakuYMD)) as mankiKeikaMonth";
	$sql .= " FROM v_chokin";
	$sql .= " WHERE (v_chokin.c_delete = 0)";
	if ($account_id <> "ALL") {
		$sql .= " and id_account = '".$account_id."'";
		if ($use_privacy == 'yes' && $account_id != $_SESSION['login_id']) {
			$sql .= " and c_privacy = 0";
		}
	}
	if ($keystring <> "") {
		$strtmp = str_replace("　", " ", $keystring);
		$keyary = explode(" ", $strtmp);
		$select_item = array();
		foreach ($item_tbl as $id=>$item) {
			if ($item['文字検索'] == "Y") {
				$select_item[] = $item['列名'];
			}
		}
		$select_item_cnt = count($select_item);			//文字列検索対象列の数
		if (count($select_item) > 0) {
			foreach ($keyary as $keytmp) {
				$sql .= " and ( ";
				for ($i=0; $i<$select_item_cnt; $i++) {
					if ($i <> 0) {
						$sql .= " or ";
					}
					$sql .= $table_name . "." . $select_item[$i] . " like '%" . $keytmp . "%'";
				}
				$sql .= " )";
			}
		}
	}
	foreach ($sel_filter as $id=>$filter) {
		if ($filter['data'] == '__blank__') {
			$sql .= " and " . $filter['colname'] . " = ''";
		} elseif ($filter['data'] <> '') {
			$sql .= " and " . $filter['colname'] . " = '" . $filter['data'] . "'";
		}
	}
	if ($add_where <> "") {
		$sql .= " and " . $add_where;
	}

	$sql2 = 'select A.*';
	$sql2 .= ", truncate((todayKeikaMonth)/12, 0) as todayYear";
	$sql2 .= ", truncate((mankiKeikaMonth)/12, 0) as mankiYear";
	$sql2 .= ", mod(todayKeikaMonth,12) as todayMonth";
	$sql2 .= ", mod(mankiKeikaMonth,12) as mankiMonth";

	$sql2 .= ', case when id_shurui = 50 and id_mankitype <> 20 and c_mankiYMD < current_date then ('; // 月積 解約 満期
	$sql2 .= ' truncate(c_keiyakuKin * pow(1 + c_ritsu/100, (mankiKeikaMonth)/23.7) * mankiKeikaMonth, 1) )';
	$sql2 .= ' when id_shurui = 50 then (';								 // 月積
	$sql2 .= ' truncate(c_keiyakuKin * pow(1 + c_ritsu/100, (todayKeikaMonth)/23.7) * todayKeikaMonth, 1) )';
	$sql2 .= ' when id_mankitype <> 20 and c_mankiYMD < current_date then (';			 // 定期 解約 満期
	$sql2 .= ' truncate(c_keiyakuKin * pow(1 + c_ritsu/100, (mankiKeikaMonth)/12), 1) )';
	$sql2 .= ' else ( truncate(c_keiyakuKin * pow(1 + c_ritsu/100, (todayKeikaMonth)/12), 1) )';	 // 定期
	$sql2 .= ' end as todayKin';

	$sql2 .= ', case when id_shurui = 50 then (';	// 月
	$sql2 .= ' truncate(c_keiyakuKin * pow(1 + c_ritsu/100, (mankiKeikaMonth)/23.7) * mankiKeikaMonth, 1) )';
	$sql2 .= ' else ( truncate(c_keiyakuKin * pow(1 + c_ritsu/100, (mankiKeikaMonth)/12), 1) )';
	$sql2 .= ' end as mankiKin';
	$sql2 .= ' from (' . $sql . ') A';
	foreach ($order_tbl as $id=>$item) {
		if ($item['get_order_name'] == $sortorder) {
			$order_item = $item['order_by'];
			//break;
		}
	}
	$sql2 .= " order by ".$order_item;
	return($sql2);
}
