<?php
function file_check_get_text($open_path, &$path_SJIS, &$source_text, &$source_encode, &$file_type, &$error_msg) {
	$path_SJIS = mb_convert_encoding($open_path, 'SJIS-win', 'UTF-8');
	if (file_exists($path_SJIS)) {
		if (is_dir($path_SJIS)) {
			$file_mode = 'Folder';
		} elseif (($file_type = chk_source_filename($open_path))) {
			$source_text = file_get_contents($path_SJIS);
			$source_encode = chk_encode($source_text);
			if ($source_encode == 'UTF-8') {
				$file_mode = 'File';
			} elseif ($source_encode == 'SJIS-win') {
				$file_mode = 'File';
				$source_text = mb_convert_encoding($source_text, 'UTF-8', $source_encode);
			} else {
				$file_mode = 'Error';
				$error_msg = 'ファイル『 '.$open_path.' 』の文字コードがサポート対象外です。';
			}
		} else {
			$file_mode = 'Error';
			$error_msg =  'ファイル『 '.$open_path.' 』の拡張子がサポート対象外です。';
		}
	} else {
		$file_mode = 'Error';
		$error_msg =  'フォルダまたはファイル『 '.$open_path.' 』が、みつかりません。';
	}
	return $file_mode;
}
function source_ext() {
	return array(
		//	拡張子		ファイルタイプ	EditArea	SyntaxHighlighter
		array(	'.php'	,	'php'	,	'php'	,	'php'		),
		array(	'.inc'	,	'php'	,	'php'	,	'php'		),
		array(	'.js'	,	'js'	,	'js'	,	'javascript'	),
		array(	'.css'	,	'css'	,	'css'	,	'css'		),
		array(	'.html'	,	'html'	,	'html'	,	'html'		),
		array(	'.htm'	,	'html'	,	'html'	,	'html'		),
		array(	'.txt'	,	'txt'	,	'html'	,	'html'		),
		array(	'.xml'	,	'xml'	,	'xml'	,	'xml'		),
		array(	'.sql'	,	'sql'	,	'sql'	,	'sql'		)
	);
}
function chk_source_filename($filename) {
	$ext_ary = source_ext();
	for($ix=0; $ix<count($ext_ary); $ix++){
		if (strtolower(strrchr($filename, '.')) == $ext_ary[$ix][0]) {
			return $ext_ary[$ix][1];
		}
	}
	return false;
}
function file_type_ea_syntax($file_type) {
	$ext_ary = source_ext();
	for($ix=0; $ix<count($ext_ary); $ix++){
		if ($file_type == $ext_ary[$ix][1]) {
			return $ext_ary[$ix][2];
		}
	}
	return false;
}
function file_type_sh_class($file_type) {
	$ext_ary = source_ext();
	for($ix=0; $ix<count($ext_ary); $ix++){
		if ($file_type == $ext_ary[$ix][1]) {
			return $ext_ary[$ix][3];
		}
	}
	return false;
}
function chk_encode($text) {
	return mb_detect_encoding($text, 'UTF-8, UTF-7, SJIS-win, SJIS, EUC-JP, eucJP-win, JIS, ISO-2022-JP, ASCII', True);
}
function filename_in_path($path) {
	return substr($path, strrpos($path,'/')+1);
}
function filename_bold_in_path($path) {
	$pos = strrpos($path, '/');
	return substr($path, 0, $pos).'/<span style="font-weight: bold;">'.substr($path, $pos+1)."</span>";
}
function error_simple_html($title, $msg) {
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<style type="text/css">
<!--
* {margin: 0px; padding: 0px; }
form { margin: 0px; }
img { border: 0px; }
body {
	background-color: #ffffff;
	margin: 5px;
	padding: 0px;
	text-align: left;
}
h2 { font-size: 120%; }
a { text-decoration: underline; font-weight: normal; }
a:link { color: #0000ff; }
a:visited { color: #0000ff; }
a:hover { color: #ff0000; }
a:active { color: #ff0000; }
body { font-size: 80%;}
body,td,a,p,.h {font-family: arial,sans-serif; }
.error_msg { color: red; margin: 20px; padding: 0; }
-->
</style>
<title><?= $title ?></title>
</head>
<body>
<p><b><?= $title ?></b></p>
<p class="error_msg"><?= $msg ?></p>
<p><a href='javascript:history.back();'>戻る</a></p>
</body>
</html>
<?php
	exit;
}
?>
