<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("__define_excel-graph.php");
	my_session_start();
	require("../account/__logincheck.php");
	require("__include-common-excel-graph.php");

	if ($_COOKIE['excel_graph_width'].'' == '') {
		$_COOKIE['excel_graph_width'] = GRAPH_WIDTH;
	}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<style type="text/css">
/* * {margin: 0px; padding: 0px; } */
/*	↓ input 除く */
body, div, img, dl, dt, dd, ul, ol, li, h1, h2, h3, h4, h5, h6, pre, form, fieldset, textarea, p, blockquote, th, td, caption {
	margin: 0; 
	padding: 0;
}
input {
	margin: 0;
}
input[type="submit"] {
	background-color: #e0e0e0;
}
input[type="reset"] {
	background-color: #e0e0e0;
}
input[type="button"] {
	background-color: #e0e0e0;
}
button {
	background-color: #e0e0e0;
}
textarea,input,select,button {
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	line-height: 1.3;
	*line-height: 1.0;
	font-size: 100%;
}
form { margin: 0px; }
img { border: 0px; }
body {
	background-color: #ffffff;
	margin: 10px;
	padding: 0px;
	text-align: left;
}
body { font-size: 84%; color: #101020; }
body,td,a,p,.h {font-family:arial,sans-serif; }
h1 { font-size: 120%; }
a { text-decoration: underline; font-weight: normal; }
a:link { color: #0000ff; font-weight: normal; }
a:visited { color: #0000ff; font-weight: normal; }
a:hover { color: #ff0000; font-weight: normal; }
a:active { color: #ff0000; font-weight: normal; }
table#data_table {
	border: #c0c0c0 1px solid;
	background-color: #ffffff;
	margin: 10px 0 0 10px;
}
#data_table th {
	padding-right: 1px; padding-left: 1px; padding-bottom: 1px; padding-top: 1px; background-color: #c0c0ff;
}
#data_table td {
	padding-right: 1px; padding-left: 1px; padding-bottom: 1px; padding-top: 1px; background-color: #e9e9e9;
}
</style>
<title>Excel to グラフ by Bluff</title>
<!--
■ Spreadsheet_Excel_Reader
	http://sourceforge.net/projects/phpexcelreader/
		http://www.ilovex.co.jp/Division/SRD/archives/2007/08/phpexcel_2.html
		http://q.hatena.ne.jp/1207023049
■ グラフ作成ライブラリ: Bluff
	http://bluff.jcoglan.com/
		http://bizcaz.com/archives/2008/09/22-220643.php
■ IEでCanvasを利用するためのライブラリ:ExplorerCanvas
	http://excanvas.sourceforge.net/
		http://d.hatena.ne.jp/unageanu/20070921/1190377760
-->
<script type="text/javascript" src="scripts/Bluff/js-class.js"></script>
<script type="text/javascript" src="scripts/Bluff/bluff-min.js"></script>
<!--[if IE]><script type="text/javascript" src="scripts/excanvas/excanvas-compressed.js"></script><![endif]-->
<script language="javascript" src="scripts/cookie.js" type="text/javascript"></script>
<script type="text/javascript">
<!--
function graphBluff(g_type, g_width, g_theme) {
	// キャンバス要素からコンテキストを取得
	var canvas = document.getElementById('graph_canvas');		// キャンバス要素
	var ctx = canvas.getContext('2d');				// 引数を'2d'として、2次元描画用のコンテキストを得る

	// グラフ種類
	// var g = new Bluff.Line('graph_canvas', 350);
	// var g = new Bluff.Bar('graph_canvas', 350);
	// ----- オブジェクト名に変数を使う方法 -----
	var graphObj = eval('Bluff.' + g_type);
	var g = new graphObj('graph_canvas', eval(g_width));		// canvas ID, 横幅

	// ビルトイン・テーマ選択(オプション)
	// g.theme_keynote();
	// g.theme_37signals();
	// g.theme_rails_keynote();
	// g.theme_pastel();
	// g.theme_odeo();
	// g.theme_greyscale();
	// ----- プロパティに変数を使う方法 -----
	g[g_theme]();

	// 読込むテーブルIDセット(必須)
	g.data_from_table('data_table');					// table ID

	// デザイン(オプション)
	g.set_theme({
		marker_color: '#95949a',				/* 横のラインの色 */
		font_color: '#330033'					/* フォントの色 */
	});

	// 最後に描画(必須)
	g.draw();
}
function onLoad() {
	g_type = loadCookie("excel_graph_type");
	g_width = loadCookie("excel_graph_width");
	g_theme = loadCookie("excel_graph_theme");
	if (g_type == "") {g_type = "Bar"};
	if (g_width == "") {g_width = <?= GRAPH_WIDTH ?>};
	if (g_theme == "") {g_theme = "theme_pastel"};
	saveCookie("excel_graph_type", g_type);
	saveCookie("excel_graph_width", g_width);
	saveCookie("excel_graph_theme", g_theme);
	graphBluff(g_type, g_width, g_theme);
}
function graphType(g_type) {
	saveCookie("excel_graph_type", g_type);
	graphBluff(g_type, loadCookie("excel_graph_width"), loadCookie("excel_graph_theme"));
}
function graphWidth(g_width) {
	saveCookie("excel_graph_width", g_width);
	graphBluff(loadCookie("excel_graph_type"), g_width, loadCookie("excel_graph_theme"));
}
function graphTheme(g_theme) {
	saveCookie("excel_graph_theme", g_theme);
	graphBluff(loadCookie("excel_graph_type"), loadCookie("excel_graph_width"), g_theme);
}
-->
</script>
</head>
<?php	if (($excel_file = post_check('filename')) == True) { ?>
<body onload="onLoad()">
<?php	} else { ?>
<body>
<?php	} ?>
<h1></h1>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" enctype="multipart/form-data">
<table>
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" size=40 name="filename" style="button-font-size:small">&nbsp;&nbsp;
		<a href="excel-graph-html5.php">「Excel to グラフ by HTML5」に切り替え</a>
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
		<input type="submit" name="clear" value="クリア">
		<input type="submit" name="redraw" value="再描画">
	</td>
</tr>
<tr>
	<td align=right>グラフ横幅：</td>
	<td>
		<select name="zoomsize" onChange="graphWidth(this.options[this.selectedIndex].value);">
		<?php 	for ($val=300; $val<=800; $val+=50) { ?>
			<option value="<?= $val ?>"<?= $val==$_COOKIE['excel_graph_width'] ? ' selected' : '' ?>><?= $val ?></option>
		<?php	} ?>
		</select>
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="button" value="　縦棒　" onClick="graphType('Bar')">
		<input type="button" value="縦棒（積）" onClick="graphType('StackedBar')">
		<input type="button" value="　横棒　" onClick="graphType('SideBar')">
		<input type="button" value="横棒（積）" onClick="graphType('SideStackedBar')">
		<input type="button" value="　線　" onClick="graphType('Line')">
		<input type="button" value="線（塗り）" onClick="graphType('Area')">
		<input type="button" value="線（塗り）（積）" onClick="graphType('StackedArea')">
		<input type="button" value="　円　" onClick="graphType('Pie')">
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="button" value="pastel" onClick="graphTheme('theme_pastel')">
		<input type="button" value="keynote" onClick="graphTheme('theme_keynote')">
		<input type="button" value="37signals" onClick="graphTheme('theme_37signals')">
		<input type="button" value="rails_keynote" onClick="graphTheme('theme_rails_keynote')">
		<input type="button" value="odeo" onClick="graphTheme('theme_odeo')">
		<input type="button" value="greyscale" onClick="graphTheme('theme_greyscale')">
	</td>
</tr>
</table>
</form>
<?php
	if ($excel_file) {
		post_done_proc($excel_file);
	}
?>
<div id="footer">
<a href="http://bluff.jcoglan.com/" target="_blank" style="color:#b0b0ff;">Powered by Bluff</a><br />
<a href="http://sourceforge.net/projects/phpexcelreader" target="_blank" style="color:#b0b0ff;">Powered by Spreadsheet_Excel_Reader</a><br />
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function post_done_proc($excel_file) {
	if ($excel_file == EXCEL_FILE_UPLOAD) {
		$attachFile = file_upload_to_name("filename", ATTACH_FILE_FOLDER, EXCEL_FILE_NAME);
		$readFile = ATTACH_FILE_FOLDER.$attachFile;
	} else {
		$readFile = ATTACH_FILE_FOLDER.EXCEL_FILE_NAME;
	}
	require 'phpExcelReader/Excel/Reader.php';
	$excel = new Spreadsheet_Excel_Reader();
	$excel->setUTFEncoder('mb');
	$excel->setOutputEncoding('UTF-8');
	$excel->read($readFile);

	if (list_table($excel, $numRows, $numCols)) {
?>
	<br>
	<div class="canvas"><canvas id="graph_canvas"></canvas></div>
<?php
	}
}
function list_table($excel, $numRows, $numCols) {
	$numRows = $excel->sheets[0]["numRows"];
	$numCols = $excel->sheets[0]["numCols"];
	if ($numRows < 2 || $numCols < 2) return False;
?>
<table id="data_table" cellspacing=1>
<caption><?= $excel->sheets[0]["sheetname"] ?></caption>
	<thead>
		<tr>
<?php
		for ($col = 1; $col <= $numCols; $col++) {
?>
			<th><?= $excel->sheets[0]["cells"][1][$col] ?></th>
<?php
		}
?>
		</tr>
	</thead>
	<tbody>
<?php
	for ($row = 2; $row <= $numRows; $row++) {
?>
		<tr>
			<th><?= $excel->sheets[0]["cells"][$row][1] ?></th>
<?php
		for ($col = 2; $col <= $numCols; $col++) {
?>
			<td align=right><?= $excel->sheets[0]["cells"][$row][$col] ?></td>
<?php
		}
?>
		</tr>
<?php
	}
?>
	</tbody>
</table>
<?php
	return True;
}
?>
