<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<meta name="description" content="ToDo">
<meta name="keywords" content="todo">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/common.css?20100923" type="text/css">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/todo.css?20090601" type="text/css">
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript">
/*	.postでは同期ができない(更新が確実に反映されない)
$(function(){
	todo_view();
	$("#todo_form").submit(function(){
		todo = document.todo_form.add_todo.value;
		color = $("#add_color").val();
		$.post('write.php', {todo:todo, color:color});
		document.todo_form.add_todo.value="";
		document.todo_form.add_todo.focus();
		todo_view();
		return false;
	});
});
*/
$(function(){
	todo_view();
	$("#todo_form").submit(function(){
		todo = document.todo_form.add_todo.value;
		color = $("#add_color").val();
		$.ajax({
			type: "POST",
			url: "write.php",
			data: "todo="+todo+"&color="+color,
			async: false,
			success: function(){
				document.todo_form.add_todo.value="";
				document.todo_form.add_todo.focus();
				todo_view();
			}
		})
		return false;
	});
});
function todo_view(){
	var d = new Date();	// キャッシュを利用されないため
	$("#todo_view").load("read.php?time="+d.getTime().toString());
}
function del_id(id){
	var d = new Date();	// キャッシュを利用されないため
	$.get("delete.php?time="+d.getTime().toString(), {id:id}, todo_view);
}
function up_id(id){
	var d = new Date();	// キャッシュを利用されないため
	$.get("priority_updown.php?time="+d.getTime().toString(), {id:id}, todo_view);
}
function down_id(id){
	var d = new Date();	// キャッシュを利用されないため
	$.get("priority_updown.php?time="+d.getTime().toString(), {id:id,ud:'d'}, todo_view);
}
$(function(){
	$('#add_color').change(function(){
		$("#add_color").css("background-color", $("#add_color option:selected").css("background-color"));
		$("#add_todo").css("color", $("#add_color option:selected").css("background-color"));
	});
});
function update_view_id(id) {
	$("#todo_update_inp"+id).css("display","");
}
function update_cancel_id(id) {
	$("#todo_update_inp"+id).css("display","none");
}
function update_done_id(id) {
	todo = $("#edit_todo"+id).val();
	color = $("#edit_color"+id).val();
	$.ajax({
		type: "POST",
		url: "update.php",
		data: "id="+id+"&todo="+todo+"&color="+color,
		async: false,
		success: function(id){
			$("#todo_update_inp"+id).css("display","none");
			document.todo_form.add_todo.focus();
			todo_view();
		}
	})
}
function update_done_id_NOT_USE(id) {
//	.postでは同期ができない(更新が確実に反映されない)
	todo = $("#edit_todo"+id).val();
	color = $("#edit_color"+id).val();
	$.post('update.php', {id:id, todo:todo, color:color});
	$("#todo_update_inp"+id).css("display","none");
	document.todo_form.add_todo.focus();
	todo_view();
}
function edit_color_chg(id) {
	$("#edit_color"+id).css("background-color", $("#edit_color"+id+" option:selected").css("background-color"));
	$("#edit_todo"+id).css("color", $("#edit_color"+id+" option:selected").css("background-color"));
}
</script>
<title>MyHome ToDo</title>
</head>
<body onload="document.todo_form.todo.focus();" onUnload="return_to_parent();" style="background-color: <?= $_SESSION['login_friends_body_background_color_'.$_SESSION['current_id']] ?>;">
<h4>MyHome ToDo <?= $_SESSION['current_handle'] ?></h4>
<div id="todo_view"></div>
<?php
	if (is_write_permit() != True) {
		error_exit('書き込み権限がありません。');
	}
?>
<form name="todo_form" id="todo_form">
<input type="text" name="add_todo" id="add_todo" size=40 value="">
<?
	todo_select_color('');
?>
<input type="submit" value="追加">
</form>
<script type="text/javascript">
function return_to_parent(){
//	window.opener.location.reload();
	window.opener.todo_view_all();
	window.opener.focus();
	window.close();
}
</script>
<button type="button" onclick="return_to_parent()">閉じる</button>
</div>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#8080ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
