<?php
	define("EXCEL_FILE_UPLOAD", 1);
	define("EXCEL_FILE_EXIST", 2);
	define("EXCEL_FILE_NAME", $_SESSION['login_id']."-excel.xls");
?>
<?php
function post_check($filename) {
	if ($_POST['upload']) {
		if (strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.xls') {
			return EXCEL_FILE_UPLOAD;
		} else {
			return false;
		}
	} elseif ($_POST['clear']) {
		return false;
	} elseif ($_POST['redraw']) {
		if (file_exists(ATTACH_FILE_FOLDER.EXCEL_FILE_NAME)) {
			return EXCEL_FILE_EXIST;
		} else {
			return false;
		}
	} else {
		if (file_exists(ATTACH_FILE_FOLDER.EXCEL_FILE_NAME)) {
			return EXCEL_FILE_EXIST;
		} else {
			return false;
		}
	}
}
function list_table($excel, &$dMatrix, &$xNums, &$yNums, &$xNames, &$yNames, $total=True) {
	$dMatrix = array();
	$xNames = array();
	$yNames = array();
	$numRows = $excel->sheets[0]['numRows'];
	$numCols = $excel->sheets[0]['numCols'];
	$xNums = $numCols - 1;
	$yNums = $numRows - 1;
	if ($numRows < 2 || $numCols < 2) return False;
?>
<table id="data_table" cellspacing=1>
<caption><?= $excel->sheets[0]['sheetname']?></caption>
	<thead>		<tr>
<?php
		for ($col=1; $col<=$numCols; $col++) {
?>
			<th style="font-size: 84%"><?= $excel->sheets[0]['cells'][1][$col] ?></th>
			<?php
			if ($col >= 2) {
				$xNames[] = $excel->sheets[0]['cells'][1][$col];
			}
			?>
<?php
		}
		if ($total) {
?>
			<th style="font-size: 84%"><b>合計</b></th>
<?php
		}
?>
		</tr>
	</thead>
	<tbody>
<?php
	$sum_c = array();
	for ($row = 2; $row <= $numRows; $row++) {
		$rdata = array();
?>
		<tr>
			<th style="font-size: 84%" align=left><?= $excel->sheets[0]['cells'][$row][1] ?></th>
<?php
		$yNames[] = $excel->sheets[0]['cells'][$row][1];
		$sum_r = 0;
		for ($col = 2; $col <= $numCols; $col++) {
			$val = $excel->sheets[0]['cells'][$row][$col];
?>
			<td style="font-size: 84%" align=right><?= $val ?></td>
<?php
			$rdata[] = $val;
			$sum_r += $val;
			$sum_c[$col] += $val;
		}
		$rdata[] = $sum_r;
		$dMatrix[] = $rdata;
		unset($rdata);
		if ($total) {
?>
			<td style="font-size: 84%" align=right><b><?= $sum_r ?></b></td>
<?php
		}
?>
		</tr>
<?php
	}
	if ($total) {
?>
		<tr>
			<td style="font-size: 84%" align=left><b>合計</b></td>
<?php
		$rdata = array();
		$sum_r = 0;
		for ($col = 2; $col <= $numCols; $col++) {
			$rdata[] = $sum_c[$col];
			$sum_r += $sum_c[$col];
?>
			<td style="font-size: 84%" align=right><b><?= $sum_c[$col] ?></b></td>
<?php
		}
		$rdata[] = $sum_r;
		$dMatrix[] = $rdata;
?>
			<td style="font-size: 84%" align=right><b><?= $sum_r ?></b></td>
		</tr>
<?php
	}
?>
	</tbody>
</table>
<?php
	return True;
}
function swap_matrix($dMatrix) {			// 行列 入れ替え
	$yxMatrix = array();
	for ($i = 0; $i < count($dMatrix[0]); $i++) {
		foreach ($dMatrix as $value) {
			$yxMatrix[$i][] = $value[$i];
		}
	}
	return $yxMatrix;
}
?>
