<?php
	require("../__common__/__define_mobile.php");
	require("__define.php");
	$login_id = mobile_login_check();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<?php
	mobile_common_head('myHome チャット');
?>
<script src="../js/jquery.tmpl.min.js"></script>
<style>
.custom-thumb {
	margin:10px;
}
.custom-opacity {
	opacity: 0.8;
}
.ui-li-has-thumb .ui-btn-inner {
	padding-left: 70px;
}
</style>
</head>
<body>
<div data-role="page" id="timeline">
	<div data-role="header">
		<a href="../index" data-icon="home" rel="external">Home</a>
		<h1>チャット</h1>
		<a href="../index" data-icon="home" data-iconpos="notext" data-direction="reverse" class="ui-btn-right jqm-home">Home</a>
	</div>
	<div data-role="content">
		<ul data-role="listview" id="list" class="ui-li-has-thumb">
		</ul>
	</div>
	<div data-role="footer" data-position="fixed" class="custom-opacity" data-id="search-menu">
		<div data-role="navbar">
			<ul>
				<li><a href="post.php" data-rel="dialog" data-theme="b" data-transition="pop" data-icon="plus" data-iconpos="top" rel="external">投稿</a></li>
				<li><a href="#" data-theme="b" data-icon="refresh" data-iconpos="top" id="search-refresh">更新</a></li>
			</ul>
		</div>
	</div>
</div>
<div data-role="page"	data-theme="d" id="search">
	<div data-role="header" data-theme="d"><h1>検索</h1></div>
	<div data-role="content">
		<input type="search" placeholder="検索条件" id="search-text" value="<?= TWITTER_KEYWORD ?>">
		<div style="text-align:center;">
			<a href="#" data-role="button" data-theme="b" data-inline="true" id="search-execute">検索</a>
			<a href="#" data-role="button" data-rel="back"	data-inline="true" data-theme="c" id="search-execute">キャンセル</a>
		</div>
	</div>
</div>
<div data-role="page" id="action">
	<div data-role="header"><h1>メニュー</h1></div>
	<div data-role="content">
		<ul data-role="listview" data-inset="true">
			<li><span class="ui-icon ui-icon-back ui-li-icon"></span><h3 style="margin-left:20px;margin-top:5px;">リプライ</h3></li>
			<li><span class="ui-icon ui-icon-refresh ui-li-icon"></span><h3 style="margin-left:20px;margin-top:5px;">リツイート</h3></li>
			<li><span class="ui-icon ui-icon-star ui-li-icon"></span><h3 style="margin-left:20px;margin-top:5px;">お気に入り</h3></li>
		</ul>
	</div>
	<div data-role="footer" data-position="fixed" class="custom-opacity" data-id="search-menu">
		<div data-role="navbar">
			<ul>
				<li><a href="post.php" data-rel="dialog" data-theme="b" data-transition="pop" data-icon="plus" data-iconpos="top" rel="external">投稿</a>
</li>
				<li><a href="#" data-theme="b" data-icon="refresh" data-iconpos="top" id="search-refresh">更新</a></li>
			</ul>
		</div>
	</div>
</div>
<script id="li-tmpl" type="text/html">
<li>
	<img src="${profile_image_url}" class="ui-li-thumb custom-thumb">
	<h3><a href="">${from_user}</a></h3>
	<p style="white-space: normal;">${text}</p>
	<p class="ui-li-aside">${created_at.getFullYear()}/${created_at.getMonth()+1}/${created_at.getDate()} ${created_at.getHours()}:${created_at.getMinutes()}:${created_at.getSeconds()}</p>
</li>
</script>
<script>
(function($){
	var URL = "read-tmpl.php";
	function search(keyword, callback) {
		$("#list").empty();
		if ( !keyword ) {
		//	$("#list").append($("<li data-role='list-dividers' data-theme='b'>" + keyword + "</li>"));
			$("#list").listview("refresh");
			if ( callback ) {
				callback();
			}
			return;
		}
		$.getJSON(URL, { q: keyword }, function(data, status) {
		//	$("#list").append($("<li data-role='list-dividers' data-theme='b'>" + keyword + "</li>"));
			$.each(data.results, function(i, message) {
				message.created_at = new Date(message.created_at);
				$("#li-tmpl").tmpl(message).appendTo("#list");
			});
			$("#list").listview("refresh");
			if ( callback ) {
				callback();
			}
		});
	}
	function searchByForm(callback) {
		search( $("#search-text").val(), callback );
	}
	$("#search-execute").bind("click", function(){
		$.mobile.pageLoading();
		searchByForm(function(){
			$.mobile.pageLoading(true);
			$(".ui-dialog").dialog("close");
		});
	});
	$("#search-refresh").bind("click", function(){
		$.mobile.pageLoading();
		searchByForm(function(){
			$.mobile.pageLoading(true);
		});
	});
	searchByForm();
})(jQuery);
</script>
</body>
</html>
