<?php
	require("__include-common.php");
	require("__include-login.php");
	require("__include-account-check.php");

	$error_msg = "";
	if (USER_SELF_NEW_ACCOUNT == 'NO') {
		exit;
	}
	if ($_POST) {
		$error_msg = post_done_proc();
	}

	html_header(HTML_TITLE, "_add_newaccount_header.php");
	page_header(False);
	input_form($error_msg);
	page_footer();
	html_footer();
	exit();
?>
<?php
function input_form($error_msg) {
?>
<div class="input_form">
<h3>ユーザー登録</h3>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<table>
<tr>
	<td nowrap>アカウント名(英数字/5～20文字)：</td>
	<td nowrap>
	<input class="text" type="text" name="account" value="<?= my_htmlspecialchars($_SESSION['newaccount_account']) ?>" size=20 onChange="AccountCheckOnChange()" style="ime-mode: disabled;">
	<button onclick="accountCheck();return false;">チェック</button>
	<span id="accountErrMsg" class="alarm_text"></span>
	</td>
</tr>
<tr>
	<td nowrap>ハンドル名(10文字以下)：</td>
	<td nowrap>
	<input class="text" type="text" name="handle" value="<?= my_htmlspecialchars($_SESSION['newaccount_handle']) ?>" size=20 onChange="HandleCheckOnChange()" style="ime-mode: active;">
	<button onclick="handleCheck();return false;">チェック</button>
	<span id="handleErrMsg" class="alarm_text"></span>
	</td>
</tr>
<tr>
	<td nowrap>電子メールアドレス</td>
	<td nowrap>
	<input class="text" type="text" name="email" value="<?= my_htmlspecialchars($_SESSION['newaccount_email']) ?>" size=40 onChange="EmailCheckOnChange()" style="ime-mode: disabled;">
	<span id="emailErrMsg" class="alarm_text"></span>
	</td>
</tr>
<tr>
	<td nowrap>パスワード(英数記号/5～30文字)：</td>
	<td nowrap>
	<input class="password" type="password" name="password" size=30 onChange="PasswordCheckOnChange()">
	<span id="passwordErrMsg" class="alarm_text"></span>
	</td>
</tr>
<tr>
	<td nowrap>パスワード(確認用の再入力)：</td>
	<td nowrap>
	<input class="password" type="password" name="password2" size=30 onChange="Password2CheckOnChange()">
	<span id="password2ErrMsg" class="alarm_text"></span>
	</td>
</tr>
<tr>
	<td nowrap>コメント(100文字以下)：</td>
	<td nowrap>
	<textarea name="msg" style="width:400px;" rows=3 wrap="soft"><?= my_htmlspecialchars($_SESSION['newaccount_msg']) ?></textarea>
	</td>
</tr>
<tr>
	<td nowrap>規約</td>
	<td nowrap>
	<textarea name="kiyaku" style="width:400px;" rows=5 wrap="soft" readonly><?= _NEWACOUNT_KIYAKU ?></textarea><br>
	<label><input name="kiyaku_confirm" type="checkbox">規約に同意します。</label>
	</td>
</tr>
</table>
	<button class="input_form_button" onclick="inputVerifyAll(); return false">確認</button>
	<input class="input_form_button" type="button" value="キャンセル" onClick="location.href='index.php'">
</form>
	<p class="error_msg"><?= $error_msg ?><p>
</div>
<?php
	return(0);
}
?>
<?php
function post_done_proc() {
	$account = form_str_adjust_strip_tags($_POST['account']);
	$handle = form_str_adjust_strip_tags($_POST['handle']);
	$password = $_POST['password'];
	$email = form_str_adjust_strip_tags($_POST['email']);
	$msg = form_str_adjust_strip_tags($_POST['msg']);
	$_SESSION['newaccount_account'] = $account;
	$_SESSION['newaccount_handle'] = $handle;
	$_SESSION['newaccount_password'] = $password;
	$_SESSION['newaccount_email'] = $email;
	$_SESSION['newaccount_msg'] = $msg;

	if (($ret = ac_chk_account($account)) <> "") return ($ret);
	if (($ret = ac_chk_handle($handle)) <> "") return ($ret);
	if (($ret = ac_chk_password($password, $_POST['password2'])) <> "") return ($ret);
	if (($ret = ac_chk_email($email)) <> "") return ($ret);
	if (($ret = ac_chk_msg($msg)) <> "") return ($ret);

	redirect("newaccount-confirm.php");
}
?>
