<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("_my_calendar.php");
	// mp_list_filter_key_select()を使うため
	require("../__common__/include-common-mp-list.php");

	if (CALENDAR_DIARY_MODE == 'diary') {
		$_SESSION['diary_back_view'] = $_SERVER['SCRIPT_NAME'].'?'.$_SERVER['QUERY_STRING'];
		$_SESSION['diary_back_view_name'] = '年間カレンダーに戻る';
	}
	if (isset($_GET['mode'])) {
		$_SESSION['calendar_mode'] = $_GET['mode'];
	}
	$arg_pool_prefix = "calendar_schedule";

	$http_arg = array();
	$http_arg['y'] = '';
	$http_arg['m'] = '';
	$http_arg['d'] = '';

	$http_arg['pl'] = PAGE_LINE_DEFAULT;		// mp_list 必須
	$http_arg['sort'] = '';				// mp_list 必須
	$http_arg['cat'] = '';				// mp_list 必須
	$http_arg['key'] = '';				// mp_list 必須

	$http_arg['selY'] = '';
	$http_arg['selM'] = '';
	$http_arg['selD'] = '';
	$http_arg['toY'] = '';
	$http_arg['toM'] = '';
	$http_arg['toD'] = '';

	_GET_to_http_arg_pool($http_arg, $arg_pool_prefix, 'selY,selM,selD,toY,toM,toD,y,m,key,sort,pl');
	$category = $http_arg['cat'];
	$keystring = keystr_fix($http_arg['key']);

	$year = $http_arg['y'];
	$month = $http_arg['m'];
	if ($year == '') {
		$year = date("Y");
	}
	if ($month == '') {
		$month = date("n");
	}
	if ($_GET['wh'] <> '') {
		$_SESSION['calendar_weather_mode'] = $_GET['wh'];
	}
	if ($_GET['tm'] <> '') {
		$_SESSION['calendar_temp_mode'] = $_GET['tm'];
		$_SESSION['calendar_weather_mode'] = 'tmp';
	} elseif ($_SESSION['calendar_temp_mode'] == '') {
		$_SESSION['calendar_temp_mode'] = 'Ave';
	}
	if (isset($_GET['ken'])) {
		$_SESSION['calendar_ken'] = $_GET['ken'];
	} elseif ($_SESSION['calendar_ken'] == '') {
		$_SESSION['calendar_ken'] = DEFAULT_TODOFUKEN_ID;
	}

	html_header(HTML_TITLE);
	page_header();
	contents_header();

	$prev_year_m = $month;
	$prev_year_y = $year - 1;
	$next_year_m = $month;
	$next_year_y = $year + 1;
	if ($month == 1) {
		$prev_month_m = 12;
		$prev_month_y = $year - 1;
		$next_month_m = $month + 1;
		$next_month_y = $year;
	} elseif ($month == 12) {
		$prev_month_m = $month - 1;
		$prev_month_y = $year;
		$next_month_m = 1;
		$next_month_y = $year + 1;
	} else {
		$prev_month_m = $month - 1;
		$prev_month_y = $year;
		$next_month_m = $month + 1;
		$next_month_y = $year;
	}
	$con = my_mysql_connect(_DB_SCHEMA);
?>
<div id="calendar_body">
<form method="POST" name="filter_form" action="<?= $_SERVER['SCRIPT_NAME'] ?>?<?= query_from_http_arg_pool($http_arg) ?>">
<table><tr><td nowrap>
<span id="calendar_category_select">
<?php
	filter_category_select($category, $_SESSION['current_id'], $http_arg);
?>
</span>
<span id="filter_key_select" class="left_mini_margin">
<?php
	filter_key_select($keystring, $http_arg);
?>
</span>
<span id="filter_mode_change" class="left_mini_margin">
<?php
	filter_mode_change();
?>
</span>
</td></tr></table>
</form>
<div id="calendar_main">
	<table>
	<caption><span class="calendar_caption_ym"><span class='calendar_caption_ym_num'><?= $year ?></span>年</span>
		<span id="calendar_ymd_change">
		<ul>
		<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= date('Y') ?>&m=<?= date('n') ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">今年</a></li>
		<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $prev_year_y ?>&m=<?= $prev_year_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">←前年</a></li>
		<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $next_year_y ?>&m=<?= $next_year_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">→次年</a></li>
		</ul>
		</span>
		<span id="calendar_ymd_select">
		<?php /* === */	if (CALENDAR_MONTH_CHANGE_STYLE <> 'OLD') { ?>
			<?php	if (strstr($_SERVER['HTTP_USER_AGENT'], "Chrome")) { ?>
			<input type="number" id="now_year" value="<?= $year ?>" style="width:4em;">年
				<?php	} else { ?>
			<script>
			function YearUpDown(id, updown) {
				$("#"+id).val(Number($("#"+id).val()) + Number(updown));
			}
			</script>
			<input type="text" id="now_year" class="text" value="<?= $year ?>" style="width:3em;"><input type="button" value="▲" style="font-size:10px;margin:0;padding:0;" OnClick="YearUpDown('now_year',1)"><input type="button" value="▼" style="font-size:10px;margin:0;padding:0;" OnClick="YearUpDown('now_year',-1)">年
			<?php	} ?>
			<script>
			function chg_Year(opt) {
				var y = $("#now_year").val();
				location.href = '?y='+y+'&'+opt;
			}
			</script>
			<button onClick="chg_Year('<?= query_string_strip('y') ?>')">Go</button>
		<?php /* === */	} else { ?>
			<select name="ChangeYear" onChange="chgFilterSelect(this, 'y', '<?= query_string_strip('y') ?>')">
		<?php
				$endYY = date("Y") + 10;
				for ($yy = _CALENDAR_SELECT_FIRST_YEAR; $yy <= $endYY; $yy++) {
		?>
			<option value="<?= $yy ?>"<?= $yy == $year ? ' selected' : '' ?>><?= $yy ?>
		<?php
				}
		?>
			</select>年
		<?php /* === */	} ?>
		</span>
	</caption>
	<tr><td>
		<table class="year_calendar_frame">
		<tr>
	<?php
		for ($month=1; $month<=12; $month++) {
			if ($month==4 || $month==7 || $month==10) {
	?>
		</tr>
		<tr>
	<?php
			}
	?>
		<td class="year_calendar_frame_month">
	<?php
			calendar_month($year, $month, $_SESSION['current_id'], $category, $keystring, "calendar_tbl_mini");
	?>
		</td>
	<?php
		}
	?>
		</tr>
		</table>
	</td>
	<td class="year_calendar_separator"><div class="year_calendar_separator_line"></div></td>
	<td>
		<table class="year_calendar_frame">
		<tr>
	<?php
		$year++;
		for ($month=1; $month<=12; $month++) {
			if ($month==4 || $month==7 || $month==10) {
	?>
		</tr>
		<tr>
	<?php
			}
	?>
		<td class="year_calendar_frame_month">
	<?php
			calendar_month($year, $month, $_SESSION['current_id'], $category, $keystring, "calendar_tbl_mini");
	?>
		</td>
	<?php
		}
	?>
		</tr>
		</table>
	</td></tr>
	</table>
</div>
<?php if ($_SESSION['calendar_mode'] <> 'album' and $_SESSION['calendar_weather_mode'] == 'wh' and strstr($_SERVER['SCRIPT_NAME'], 'calendar')) { ?>
<div id="notation_area">
	<p class="notation_level">晴が<?= WEATHER_RATIO_LEVEL_1 ?>%以上</p>
	<div class="notation_box">
		<div class="notation_color weather_bg_fine"></div><span style="float: left;">：</span>
		<img class="notation_img" src="../icon/weather/fine.gif" />
	</div>
	<p class="notation_level">晴が<?= WEATHER_RATIO_LEVEL_2 ?>%以上</p>
	<div class="notation_box">
		<div class="notation_color weather_bg_fine_cloud"></div><span style="float: left;">：</span>
		<img class="notation_img" src="../icon/weather/fine_cloud.gif" />
	</div>
	<p class="notation_level">晴が<?= WEATHER_RATIO_LEVEL_3 ?>%以上</p>
	<div class="notation_box">
		<div class="notation_color weather_bg_fine_rain"></div><span style="float: left;">：</span>
		<img class="notation_img" src="../icon/weather/fine_rain.gif" />
	</div>
	<p class="notation_level">晴が<?= WEATHER_RATIO_LEVEL_3 ?>%未満</p>
	<div class="notation_box">
		<div class="notation_color weather_bg_cloud"></div><span style="float: left;">：</span>
		<img class="notation_img" src="../icon/weather/cloud.gif" />
	</div>
	<div class="notation_box">
		<div class="notation_color weather_bg_rain"></div><span style="float: left;">：</span>
		<img class="notation_img" src="../icon/weather/rain.gif" />
	</div>
	<div class="notation_box">
		<div class="notation_color weather_bg_snow"></div><span style="float: left;">：</span>
		<img class="notation_img" src="../icon/weather/snow.gif" />
	</div>
</div>
<?php } elseif ($_SESSION['calendar_mode'] <> 'album' and $_SESSION['calendar_weather_mode'] == 'tmp' and strstr($_SERVER['SCRIPT_NAME'], 'calendar')) { ?>
<div id="notation_area">
	<p class="notation_level">平均気温</p>
	<div class="notation_box">
	<div class="notation_color temp_bg_burn"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_0 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_vhot"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_1 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_hot"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_2 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_warm"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_3 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_nice"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_4 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_cool"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_5 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_cold"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_6 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_iced"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_7 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_freeze"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_8 ?>℃以上</span>
	</div>
	<div class="notation_box">
	<div class="notation_color temp_bg_pain"></div><span style="float: left;"><?= WEATHER_TEMP_LEVEL_8 ?>℃未満</span>
	</div>
</div>
<? } ?>
</div>
<?php
	page_footer();
	html_footer();
	exit();
?>
