<?php
//	error_reporting(E_ALL);
//	ini_set('display_errors', '1');
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("__define_code-file.php");
	require("__include-common-code-file.php");
	define("MY_SYSTEM_OS", left(php_uname(), 7));	// Windows, Linux, FreeBSD, Mac, ...
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (FILE_MANAGER_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	if (!defined("FILE_MANAGER_DEFAULT_FOLDER")) {
		define("FILE_MANAGER_DEFAULT_FOLDER", $_SERVER['DOCUMENT_ROOT']);
	}
	if ($_GET['path'].'' <> '') {
		$open_path = my_GET('path');
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, "/", right_slash_strip($open_path));
	if ($open_path == "") {
		$open_path = FILE_MANAGER_DEFAULT_FOLDER;
	}
	$file_mode = folder_check($open_path, $path_SJIS, $error_msg);
	if ($file_mode == 'Folder') {
		view_folder($open_path, $path_SJIS, $_SESSION['file_manager_search_key']);
//	} else {
//		echo '<p class="error_msg">'.$error_msg.'</p>';
	}
?>
<?php
function view_folder($open_path, $path_SJIS, $search_key) {
	$prt_dir = array();
	$prt_file = array();
	if ($dir = opendir($path_SJIS)) {
		$files = scandir($path_SJIS);
	//	natcasesort($files);		/* サーバーサイドでのソートを廃止。*/
		$order = 0;
		error_reporting(0);	// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
		foreach ($files as $file) {
			if ($file != "." && $file != "..") {
				$filepath_SJIS = $path_SJIS.'/'.$file;
				if (is_dir($filepath_SJIS)) {
					if ($_GET['get'] == 'dir') {
						$prt_dir[] = $file;
					}
				} else {
					if ($_GET['get'] == 'file') {
						$type = chk_filemanager_filename($file);
						$ext = strtolower(strrchr($file, '.'));
						if ($type == False) {
							if ($ext == '.encode3' or $ext == '.encode2' or $ext == '.encode') {
								$type = 'encode';
							} else if ($ext == '.zip') {
								$type = 'zip';
							} else {
								$type = 'other';
							}
						}
						if (($stat = stat($filepath_SJIS)) <> False) {
							if (MY_SYSTEM_OS <> 'Windows') {
								$permission = substr(sprintf("%03o", $stat['mode']), -3);
								// $userinfo = posix_getpwuid($stat['uid']);
								// $username = $userinfo['name'];
							} else {
								$permission = '';
							}
							$prt_file[] = array($file, $type, $stat['size'], $stat['mtime'], $ext, $permission);
						} else {
							// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
							$prt_file[] = array($file, $type, 0, 0, '', '');
						}
						// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
						$prt_order[] = ++$order;
					}
				}
			}
		}
		error_reporting(E_ALL ^ E_NOTICE);
		closedir($dir);
	}
	if ($_GET['get'] == 'dir') {
		print_dir($open_path, $prt_dir, $search_key);
	} elseif ($_GET['get'] == 'file') {
		print_file($open_path, $prt_file, $search_key, $prt_order);
	}
}
function print_dir($open_path, $prt_dir, $search_key) {
?>
	<ul class="file_list">
<?php
	foreach ($prt_dir as $dir) {
		$file_UTF = myfile_DECODE($dir);
		$path_UTF = $open_path.'/'.myfile_DECODE($dir);
		if ($search_key == '' or ($search_key <> '' and stristr(basename($path_UTF), $search_key)) ) {
?>
		<li class="file_folder"><a href="file-manager.php?path=<?= urlencode($path_UTF) ?>&key=<?= urlencode($search_key) ?>"><?= $file_UTF ?></a>
		<input type="button" class="copy_button" value="Ｃ" onClick="copy_folder('<?= escape_squote($path_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｒ" onClick="rename_folder('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｄ" onClick="delete_folder('<?= escape_squote($path_UTF) ?>')">
		</li>
<?php
		}
	}
?>
	</ul>
<?php
}
function print_file($open_path, $prt_file, $search_key, $prt_order) {
	if (!$prt_file[0]) return;
?>
	<table cellspacing="1" id="sorttable" class="tablesorter">
	<thead>
	<tr>
	<th>ファイル名</th>
	<th>サイズ</th>
	<th>更新日時</th>
<?php	if (MY_SYSTEM_OS <> 'Windows') { ?>
	<th>rwx</th>
<?php	} ?>
	<th>種類</th>
	</tr>
	</thead>
	<tbody>
<?php
	foreach ($prt_file as $file) {
		$file_UTF = myfile_DECODE($file[0]);
		$path_UTF = $open_path.'/'.myfile_DECODE($file[0]);
		$path_SJIS = myfile_ENCODE($path_UTF);
		if ($search_key == '' or ($search_key <> '' and stristr($file_UTF, $search_key)) ) {
?>
		<tr>
		<td>
		<?php
			if (!myfile_file_exists($path_UTF)) {
				$filename_err = True;
			} else {
				$filename_err = False;
			}
		?>
		<?php if ($filename_err) { ?>
			<span style="color:red;">エラー：</span> <?= $file_UTF ?></span>
		<?php } elseif ($file[1] == 'encode') { ?>
			<?php $cip_val = '←復号化' ?>
			<span class="file_<?= $file[1] ?>"><?= $filename_err ?>
				<a href="file-download.php?path=<?= urlencode($path_UTF) ?>"><span class="encode_file"><?= $file_UTF ?></span></a>
			</span>
		<?php } else { ?>
			<?php $cip_val = '暗号化' ?>
			<span class="file_<?= $file[1] ?>"><?= $filename_err ?>
				<a href="file-download.php?path=<?= urlencode($path_UTF) ?>"><?= $file_UTF ?></a>
			</span>
		<?php } ?>
		<?php if (!$filename_err) { ?>
			<?php if ($file[1] == 'zip') { ?>
				<input type="button" class="copy_button" value="unZip" onClick="unzip_file('<?= $path_UTF ?>', '<?= substr($file_UTF, 0, -4) ?>')">
			<?php } else if (chk_source_filename($file[0])) { ?>
				<input type="button" class="copy_button" value="Ｓ" onClick="window.open().location.href='code-file-view.php?path=<?= urlencode($path_UTF) ?>'">
			<?php } ?>
			<?php if (defined("FILE_MANAGER_CIPHER_SEED") and FILE_MANAGER_CIPHER_SEED <> '') { ?>
			<input type="button" class="copy_button" value="<?= $cip_val ?>" onClick="cipher_file('<?= escape_squote($path_UTF) ?>')">
			<?php } ?>
			<input type="button" class="copy_button" value="Ｃ" onClick="copy_file('<?= escape_squote($path_UTF) ?>')">
			<input type="button" class="copy_button" value="Ｒ" onClick="rename_file('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
			<input type="button" class="copy_button" value="Ｄ" onClick="delete_file('<?= escape_squote($path_UTF) ?>')">
		<?php } ?>
		</td>
		<td class="file_size"><?= ceil($file[2]/1024) ?> KB</td>
		<td class="file_time"><?= date("Y/m/d H:i", $file[3]) ?></td>
		<?php	if (MY_SYSTEM_OS <> 'Windows') { ?>
		<td class="file_time"><?= $file[5] ?></td>
		<?php	} ?>
		<td class="file_time"><?= substr($file[4],1) ?></td>
	</tr>
<?php
		}
	}
?>
	</tbody>
	</table>
<?php
}
function folder_check($open_path, &$path_SJIS, &$error_msg) {
	$path_SJIS = myfile_ENCODE($open_path);
	if (file_exists($path_SJIS)) {
		if (is_dir($path_SJIS)) {
			return 'Folder';
		} else {
			$error_msg =  'ファイル『 '.$open_path.' 』は表示できません。';
			return 'File';
		}
	} else {
		$error_msg =  'フォルダまたはファイル『 '.$open_path.' 』が、みつかりません。';
		return 'Error';
	}
}
?>
