<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<?php
	define('TABLE_BACKGROUND_COLOR', '#A0A0A0');
	DEFINE('TH_BACKGROUND_COLOR', '#00C0C0');
	DEFINE('TD_BACKGROUND_COLOR', '#E8F8FF');
	DEFINE('TH_FONT_COLOR', '#FFFFFF');
	DEFINE('TD_FONT_COLOR', '#000000');
	DEFINE('TABLE_BORDER_COLOR', '#A0A0A0');
	define('TH_TD_BORDER_COLOR', '#A0A0A0');
	define('TABLE_BORDER_WIDTH', '1px');
	define('TH_TD_BORDER_WIDTH', '1px');
?>
<style>
body, div, img, ul, ol, li, p, th, td, form, pre, dl, dt, dd, fieldset, blockquote, caption, h1, h2, h3, h4, h5, h6 {
	margin: 0;
	padding: 0;
}
body {margin: 10px; }
input, select, textarea { margin: 0; }
img { border: 0; }
body {
	background-color: #ffffff;
	text-align: left;
	font-family: "MS PGothic","Osaka",Arial,sans-serif;
}
body, input, button, textarea {
	font-size: 12px;
	line-height: 1.2;
}
button, input[type="button"], input[type="submit"], input[type="reset"] {
	overflow: visible;
	margin: 1px 0;
	padding: 1px 3px;
	padding: 0 2px\9;	/* IE8以下 */
}
body:not(:target) {
	padding: 0 2px\9;	/* IE9 */
}
body {
	margin: 10px 20px 10px 20px;
}
h1 { font-size: 140%; font-weight: bold; }
h2 { font-size: 130%; font-weight: bold; }
h3 { font-size: 120%; font-weight: bold; margin: 0 0 5px 0; }
h4 { font-size: 110%; font-weight: bold; }
td { text-align: left; vertical-align: top; }
a { text-decoration: underline; font-weight: normal; }
a:link { color: #0000ff; font-weight: normal; }
a:visited { color: #0000ff; font-weight: normal; }
a:hover { color: #ff0000; font-weight: normal; }
a:active { color: #ff0000; font-weight: normal; }
</style>
<script src="../scripts/jquery.js"></script>
<script>
<!--
var pool_style = {
//	変更したスタイルデータのプール領域
//	JavaScriptでは通常変数では参照渡しができないので、連想配列(オブジェクト)を使用。

	bgColorTABLE: "<?= TABLE_BACKGROUND_COLOR ?>",
	bgColorTH: "<?= TH_BACKGROUND_COLOR ?>",
	bgColorTD: "<?= TD_BACKGROUND_COLOR ?>",
	fontColorTH: "<?= TH_FONT_COLOR ?>",
	fontColorTD: "<?= TD_FONT_COLOR ?>",
	borderColorTABLE: "<?= TABLE_BORDER_COLOR ?>",
	borderColorTH: "<?= TH_TD_BORDER_COLOR ?>",
	borderColorTD: "<?= TH_TD_BORDER_COLOR ?>",
	borderWidthTABLE: "<?= TABLE_BORDER_WIDTH ?>",
	borderWidthTH: "<?= TH_TD_BORDER_WIDTH ?>",
	borderWidthTD: "<?= TH_TD_BORDER_WIDTH ?>"
};
function color_Change_THTD_Border(chgColorInput) {
	colorNew = document.getElementById(chgColorInput).value;
	if (colorNew != "") {
		$('#'+chgColorInput+'_icon').css('color', colorNew);
		css_Change_Do('borderColorTH', 'th', 'border-color', colorNew);
		css_Change_Do('borderColorTD', 'td', 'border-color', colorNew);
	}
}
function color_Change_BG_ALL(chgColorInput) {
	colorNew = document.getElementById(chgColorInput).value;
	if (colorNew != "") {
		document.getElementById('borderColorTABLE').value = colorNew;
		document.getElementById('borderColorTHTD').value = colorNew;
		color_Change('bgColorTABLE', 'table', 'background-color');
		color_Change('borderColorTABLE', 'table', 'border-color');
		color_Change_THTD_Border('borderColorTHTD');
	}
}
function color_Change(chgColorInput, targetHTML, targetCSS) {
	colorNew = document.getElementById(chgColorInput).value;
	if (colorNew != "") {
		$('#'+chgColorInput+'_icon').css('color', colorNew);
		css_Change_Do(chgColorInput, targetHTML, targetCSS, colorNew);
	}
}
function borderWidthTABLE_Change(px) {
	css_Change_Do('borderWidthTABLE', 'table', 'border-width', px);
}
function borderWidthTHTD_Change(px) {
	css_Change_Do('borderWidthTH', 'th', 'border-width', px);
	css_Change_Do('borderWidthTD', 'td', 'border-width', px);
	for (ix=0; ix<=2; ix++) {
		for (jx=3; jx<=4; jx++) {						// th td border-width: (n)px 0 0 0;
			$('tr.tr'+jx+ix+' th').css('border-left-width', 0);
			$('tr.tr'+jx+ix+' th').css('border-right-width', 0);
			$('tr.tr'+jx+ix+' th').css('border-bottom-width', 0);
			$('tr.tr'+jx+ix+' td').css('border-left-width', 0);
			$('tr.tr'+jx+ix+' td').css('border-right-width', 0);
			$('tr.tr'+jx+ix+' td').css('border-bottom-width', 0);
		}
	}
}
function css_Change_Do(PoolVarName, targetHTML, targetCSS, newValue) {
	$(targetHTML+'.my').css(targetCSS, newValue);
	if (targetCSS == 'background-color') {
		for (ix=1; ix<=tableCnt; ix++) {
			$(targetHTML+'#table'+ix+'2').css(targetCSS, '#FFFFFF');	// background-color: #FFFFFF 固定
		}
	}
	htmlView_Replace('#'+targetHTML+'View', targetCSS+': '+pool_style[PoolVarName], targetCSS+': '+newValue);
	pool_style[PoolVarName] = newValue;
}
function htmlView_Replace(idName, nowStr, newStr) {
	for (ix=1; ix<=tableCnt; ix++) {
		$(idName+ix+"0").html($(idName+ix+"0").html().replace(nowStr, newStr));
		$(idName+ix+"1").html($(idName+ix+"1").html().replace(nowStr, newStr));
		$(idName+ix+"2").html($(idName+ix+"2").html().replace(nowStr, newStr));
	}
}
-->
</script>
<title>HTML テーブル CSSスタイル シミュレーション</title>
</head>
<body>
<h1>HTML テーブル CSSスタイル シミュレーション</h1>
<div>
<form>
	<input class="text" type="text" id="bgColorTABLE" name="bgColorTABLE" value="<?= TABLE_BACKGROUND_COLOR ?>" size="10">
		<span id="bgColorTABLE_icon" style="color: <?= TABLE_BACKGROUND_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TABLE background"
		onClick="color_Change('bgColorTABLE', 'table', 'background-color')">
		<input type="button" class="button" value="TABLE background & TABLE,TH,TD border 一括"
		onClick="color_Change_BG_ALL('bgColorTABLE')">
<br>
	<input class="text" type="text" id="borderColorTABLE" name="borderColorTABLE" value="<?= TABLE_BORDER_COLOR ?>" size="10">
		<span id="borderColorTABLE_icon" style="color: <?= TABLE_BORDER_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TABLE border"
		onClick="color_Change('borderColorTABLE', 'table', 'border-color')">
	<select name="zoomsize" onChange="borderWidthTABLE_Change(this.options[this.selectedIndex].value);">
	<?php	for ($ix=0; $ix<=5; $ix++) { ?>
		<option value="<?= $ix ?>px"<?= $ix == TABLE_BORDER_WIDTH ? ' selected' : '' ?>><?= $ix ?>px</option>
	<?php	} ?>
		</select>
	<input class="text" type="text" id="borderColorTHTD" name="borderColorTHTD" value="<?= TH_TD_BORDER_COLOR ?>" size="10">
		<span id="borderColorTHTD_icon" style="color: <?= TH_TD_BORDER_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TH TD border"
		onClick="color_Change_THTD_Border('borderColorTHTD');">
	<select name="zoomsize" onChange="borderWidthTHTD_Change(this.options[this.selectedIndex].value);">
	<?php	for ($ix=0; $ix<=5; $ix++) { ?>
		<option value="<?= $ix ?>px"<?= $ix == TH_TD_BORDER_WIDTH ? ' selected' : '' ?>><?= $ix ?>px</option>
	<?php	} ?>
		</select>
<br>
	<input class="text" type="text" id="bgColorTH" name="bgColorTH" value="<?= TH_BACKGROUND_COLOR ?>" size="10">
		<span id="bgColorTH_icon" style="color: <?= TH_BACKGROUND_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TH background"
		onClick="color_Change('bgColorTH', 'th', 'background-color')">
	<input class="text" type="text" id="bgColorTD" name="bgColorTD" value="<?= TD_BACKGROUND_COLOR ?>" size="10">
		<span id="bgColorTD_icon" style="color: <?= TD_BACKGROUND_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TD background"
		onClick="color_Change('bgColorTD', 'td', 'background-color')">
<br>
	<input class="text" type="text" id="fontColorTH" name="fontColorTH" value="<?= TH_FONT_COLOR ?>" size="10">
		<span id="fontColorTH_icon" style="color: <?= TH_FONT_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TH font"
		onClick="color_Change('fontColorTH', 'th', 'color')">
	<input class="text" type="text" id="fontColorTD" name="fontColorTD" value="<?= TD_FONT_COLOR ?>" size="10">
		<span id="fontColorTD_icon" style="color: <?= TD_FONT_COLOR ?>; font-size: 120%;">■</span>
		<input type="button" class="button" value="TD font"
		onClick="color_Change('fontColorTD', 'td', 'color')">
	<span style="padding: 0 0 0 100px;"><a href="../__common__/color-chart.php" target="_blank">↑カラーチャート</a></span>
</form>
</div>
<?php
	$layout = array();
	$layout[] = array('collapse'=>'separate',
			'tableBorderStyle'=>'solid',
			'tableBorderWidth'=>TABLE_BORDER_WIDTH,
			'thTdBorderStyle'=>'none',
			'thTdBorderWidth'=>TH_TD_BORDER_WIDTH);
	$layout[] = array('collapse'=>'separate',
			'tableBorderStyle'=>'solid',
			'tableBorderWidth'=>TABLE_BORDER_WIDTH,
			'thTdBorderStyle'=>'solid',
			'thTdBorderWidth'=>TH_TD_BORDER_WIDTH);
	$layout[] = array('collapse'=>'separate',
			'tableBorderStyle'=>'solid',
			'tableBorderWidth'=>TABLE_BORDER_WIDTH,
			'thTdBorderStyle'=>'solid',
			'thTdBorderWidth'=>TH_TD_BORDER_WIDTH.' 0 0 0');
	$layout[] = array('collapse'=>'collapse',
			'tableBorderStyle'=>'none',
			'tableBorderWidth'=>TABLE_BORDER_WIDTH,
			'thTdBorderStyle'=>'solid',
			'thTdBorderWidth'=>TH_TD_BORDER_WIDTH.' 0 0 0');
	$layout[] = array('collapse'=>'separate',
			'tableBorderStyle'=>'solid',
			'tableBorderWidth'=>TABLE_BORDER_WIDTH,
			'thTdBorderStyle'=>'inset',
			'thTdBorderWidth'=>TH_TD_BORDER_WIDTH);
	$layout[] = array('collapse'=>'separate',
			'tableBorderStyle'=>'solid',
			'tableBorderWidth'=>TABLE_BORDER_WIDTH,
			'thTdBorderStyle'=>'outset',
			'thTdBorderWidth'=>TH_TD_BORDER_WIDTH);
	$colorSet = array(	'table_background'=>TABLE_BACKGROUND_COLOR,
				'th_background'=>TH_BACKGROUND_COLOR,
				'td_background'=>TD_BACKGROUND_COLOR,
				'th_font'=>TH_FONT_COLOR,
				'td_font'=>TD_FONT_COLOR,
				'table_border'=>TABLE_BORDER_COLOR,
				'th_td_border'=>TH_TD_BORDER_COLOR);
?>
<table>
	<tr>
		<th colspan=2>border-spacing:0px;</th>
		<th colspan=2>border-spacing:1px;</th>
		<th colspan=2>border-spacing:1px;<br>table background-color: #ffffff 固定</th>
	</tr>
<?php
	foreach ($layout as $each_layout) {
		$table_cnt = table_layout($each_layout, $colorSet);
	}
?>
</table>
<script>
<!--
var tableCnt = <?= $table_cnt ?>;
-->
</script>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#8080ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function table_layout($layout, $colorSet) {
	static $cnt = 0;
	++$cnt;
?>
	<tr>
<?php
	$tableStyle = "border-collapse: ".$layout['collapse'].";";
	$tableStyle .= " border-style: ".$layout['tableBorderStyle'].";";
	$tableStyle .= " border-width: ".$layout['tableBorderWidth'].";";
	$tableStyle .= " border-color: ".$colorSet['table_border'].";";
	$tableStyle .= " background-color: ".$colorSet['table_background'].";";

	$thStyle = " color: ".$colorSet['th_font'].";";
	$thStyle .= " border-style: ".$layout['thTdBorderStyle'].";";
	$thStyle .= " border-width: ".$layout['thTdBorderWidth'].";";
	$thStyle .= " border-color: ".$colorSet['th_td_border'].";";
	$thStyle .= " background-color: ".$colorSet['th_background'].";";
	$thStyle .= " padding: 2px;";

	$tdStyle = " color: ".$colorSet['td_font'].";";
	$tdStyle .= " border-style: ".$layout['thTdBorderStyle'].";";
	$tdStyle .= " border-width: ".$layout['thTdBorderWidth'].";";
	$tdStyle .= " border-color: ".$colorSet['th_td_border'].";";
	$tdStyle .= " background-color: ".$colorSet['td_background'].";";
	$tdStyle .= " padding: 2px;";

		table_style_view($tableStyle, $thStyle, $tdStyle, $cnt.'0', 0);
		table_style_view($tableStyle, $thStyle, $tdStyle, $cnt.'1', 1);

	$tableStyle = "border-collapse: ".$layout['collapse'].";";
	$tableStyle .= " border-style: ".$layout['tableBorderStyle'].";";
	$tableStyle .= " border-width: ".$layout['tableBorderWidth'].";";
	$tableStyle .= " border-color: ".$colorSet['table_border'].";";
	$tableStyle .= " BACKGROUND-COLOR: #FFFFFF;";

		table_style_view($tableStyle, $thStyle, $tdStyle, $cnt.'2', 1);
?>
	</tr>
<?php
	return $cnt;
}
function table_style_view($tableStyle, $thStyle, $tdStyle, $id, $cellspacing) {
?>
	<td>
		<table class="my" id="table<?= $id ?>" style="border-spacing:<?= $cellspacing ?>px;<?= $tableStyle ?>">
		<tr class="tr<?= $id ?>">
			<th nowrap class="my" style="<?= $thStyle ?>">見出し</th>
			<th nowrap class="my" style="<?= $thStyle ?>">見出し</th>
		</tr>
		<tr class="tr<?= $id ?>">
			<td nowrap class="my" style="<?= $tdStyle ?>">データ</td>
			<td nowrap class="my" style="<?= $tdStyle ?>">データ</td>
		</tr>
		<tr class="tr<?= $id ?>">
			<td nowrap class="my" style="<?= $tdStyle ?>">データ</td>
			<td nowrap class="my" style="<?= $tdStyle ?>">データ</td>
		</tr>
		</table>
	</td>
	<td class="description" nowrap>
		<table>
			<tr><td>&lt;table&gt;</td><td>border-spacing:<?= $cellspacing ?>px;</td><tr>
			<tr><td>&lt;table&gt;</td><td id="tableView<?= $id ?>"><?= style_view($tableStyle) ?></td><tr>
			<tr><td>&lt;th&gt;</td><td id="thView<?= $id ?>"><?= style_view($thStyle) ?></td><tr>
			<tr><td>&lt;td&gt;</td><td id="tdView<?= $id ?>"><?= style_view($tdStyle) ?></td><tr>
		</table>
	</td>
<?php
}
function style_view($str) {
	return str_replace(";", ";<br>", $str);
}
?>
