<?php
function ac_chk_account($account) {
	if (strlen($account) < ACCOUNT_ID_NAME_MIN_LENGTH) {
		return "アカウントは、".ACCOUNT_ID_NAME_MIN_LENGTH."文字以上にしてください。";
	}
	if (strlen($account) > 20) {
		return "アカウントは、20文字以下にしてください。";
	}
	if (strpos($account,"admin") !== False or mb_substr($account,0,4) == "root") {
		return "そのアカウントは使用できません。";
	}
	if (checkIsAlphaNum($account) == False) {
		return "アカウントには、英数字以外は使えません。";
	}
	$con_account = my_mysqli_connect(_DB_ACCOUNT_SCHEMA, False);
	$sql = "SELECT * FROM m_account WHERE c_account = '" . str_for_mysql($account) . "'";
	$rs = my_mysqli_query($sql);
	if ($rs) {
		$row = mysqli_num_rows($rs);
		if ($row <> 0) {
			mysqli_close($con_account);
			return "そのアカウントは既に使われています。";
		}
	} else {
		return "エラーが発生しました。(select account error)";
	}
	mysqli_close($con_account);
	return "";
}
function ac_chk_handle($handle, $login_id="") {
	if ($handle == "") {
		return "ハンドル名を入れてください。";
	}
	if (strlen($handle) > 30) {
		return "ハンドル名は、10文字以下にしてください。";
	}
//	if (checkIsZenkaku($handle) == False) {
//		return "ハンドル名には、全角文字以外は使えません。";
//	}
	if (strpos($handle,"管理") !== False or strpos($handle,"システム") !== False or strpos($handle,"特権") !== False or strpos($handle,"admin") !== False or mb_substr($handle,0,4) == "root") {
		return "そのハンドル名は使用できません。";
	}
	$con_account = my_mysqli_connect(_DB_ACCOUNT_SCHEMA, False);
	$sql = "SELECT * FROM m_account WHERE c_handle = '" . str_for_mysql($handle) . "'";
	if ($login_id <> "") {	// 修正の場合の現在のアカウントID
		$sql .= " and id_account <> '" . $login_id . "'";
	}
	$rs = my_mysqli_query($sql);
	if ($rs) {
		$row = mysqli_num_rows($rs);
		if ($row <> 0) {
			mysqli_close($con_account);
			return "そのハンドル名は既に使われています。";
		}
	} else {
		return "エラーが発生しました。(select handle error)";
	}
	mysqli_close($con_account);
	return "";
}
function ac_chk_password($password, $password2) {
	if (strlen($password) < ACCOUNT_PASSWORD_MIN_LENGTH) {
		return "パスワードは、".ACCOUNT_PASSWORD_MIN_LENGTH."文字以上にしてください。";
	}
	if (strlen($password) > 30) {
		return "パスワードは、30文字以下にしてください。";
	}
	if (strpos($password," ")) {
		return "パスワードに空白が含まれています。";
	}
	if ($password <> $password2) {
		return "確認用のパスワードが違っています。";
	}
	return "";
}
function ac_chk_email($email) {
	if ($email == "") {
		return "";
	}
			//	if (checkIsMailAddr($email) == False) {
			//		return "電子メールアドレスが間違っています。";
			//	}
	return "";
}
function ac_chk_msg($msg) {
	if (strlen($msg) > 300) {
		return "コメントは、100文字以下にしてください。";
	}
	return "";
}
function checkIsAlphaNum($string) {
	if (preg_match("/^[a-zA-Z0-9]+$/", $string)) {
		return true;
	} else {
		return false;
	}
}
function checkIsZenkaku($string) {
	// UTF-8
	$strcnt = mb_strlen( $string ) * 3;
	$strlen = strlen( $string );
	if ($strlen <> $strcnt) {
		return false;
	}
	return true;
}
function checkIsZenkaku_Shift_JIS($string) {
	$strcnt = mb_strlen( $string ) * 2;
	$strlen = strlen( $string );
	if ($strlen <> $strcnt) {
		return false;
	}
	return true;
}
function checkIsMailAddr($mailaddress) {
	if (preg_match('/^[a-zA-Z0-9_\.\-]+@[A-Za-z0-9]+\.[A-Za-z0-9]+$/',$mailaddress)) {
		return true;
	} else {
		return false;
	}
}
?>
