<?php
// Powered by http://wp.rapidexp.com/2009/01/fpdf/

define('MY_FPDF_PATH', 'fpdf');
define('MY_ENCODING', 'SJIS');
define('MM_PER_POINT', '0.5');
if (!defined("PDF_PATH")) {
	define('PDF_PATH', "../pdf/");
}
include_once PDF_PATH.MY_FPDF_PATH.'/pdf-inc.php';
include_once 'fpdf/pdf-inc.php';

// クラス初期化と用紙サイズ指定
//（引数と省略時の初期値）
// $orientation="P", $unit="mm", $format="A4", $families=array(PMINCHO)
$o_pdf = new my_class_pdf("P", "mm", "Postcard", array(GOTHIC, PGOTHIC));

// ページ追加
// $family=PMINCHO, $template=""
$o_pdf->add_page(GOTHIC, "hagaki-form.pdf");

// 水平
// $x, $y, $size, $text, $max_width=0, $align="left", $space=0, $style="", $family=""
$o_pdf->text_horizontal(46.2, 18.0, 13, "163", 0, "left", 4.6);
$o_pdf->text_horizontal(67.7, 18.0, 13, "8001",   0, "left", 4.6);

// 垂直
// $x, $y, $size, $text, $max_height=0, $valign="top", $space=0, $style="", $family=""
list($size) = $o_pdf->text_vertical(92, 30, 12, sjis("東京都新宿区西新宿1-8-1"), 90);
$o_pdf->text_vertical(86, 30, $size, sjis("第一本庁舎15F北"), 90, "bottom");
$o_pdf->text_vertical(76, 30, 15, sjis("東京オリンピック・パラリンピック招致本部"), 90);
$o_pdf->text_vertical(70, 40, 15, sjis("招致推進部"), 80);
list($size, $y) = $o_pdf->text_vertical(60, 30, 20, sjis("東京　太郎　様"), 90, "middle", 2, "B");
$o_pdf->text_vertical(50, $y, $size, sjis("〓　花子　様"), 0, "top", 2, "B");

// ２ページ目
$o_pdf->add_page(PGOTHIC, "hagaki-form.pdf");

// 90度回転
$x = 50;
$o_pdf->text_rotate90($x, 100, 14, "President Barack H. Obama, Jr.", 70, "left", "B");
$x += 6;
$o_pdf->text_rotate90($x, 100, 11, "The White House", 70);
$x += 10;
$o_pdf->text_rotate90($x, 100, 11, "1600 Pennsylvania Avenue NW", 70);
$x += 5;
$o_pdf->text_rotate90($x, 100, 11, "Washington DC 20500, USA", 70);

// 出力
// $name="doc.pdf", $zone="default"
$o_pdf->output('test-sample.pdf', "real", 'F');
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
</head>
<body>
<p><a href="./test-sample.pdf">PDFファイル</a></p>
</body></html>
<?php
function sjis($str) {
	return mb_convert_encoding($str, 'SJIS-win', 'UTF-8');
}
?>
