<?php
	require("../__common__/__define_common.php");
	require("__define.php");
	require("../__common__/include-common-all.php");
	require("../account/__logincheck.php");
	require("img-view-include.php");
	if (($img_file = my_GET('img').'') == '') {
		exit;
	}
	if (defined("photo_LIMITED_IMAGES_FOLDER") and photo_LIMITED_IMAGES_FOLDER <> '') {
		if ($_SESSION['システム管理者'] <> "YES" or photo_LIMITED_ADMIN_NOLIMIT <> 'YES') {
			$len = strlen(photo_LIMITED_IMAGES_FOLDER);
			if (substr($img_file, 0, $len) <> photo_LIMITED_IMAGES_FOLDER) {
				exit;
			}
		}
	}
	if (is_video_filename($img_file)) {
		$getimg = "video-jpeg.php?file=".urlencode($img_file);
	} else {
		$getimg = "img-view.php?img=".urlencode($img_file);
	}
	if (!defined("IMAGEFILTERS_RIPPLE_SIZE_SELECT")) {
		define("IMAGEFILTERS_RIPPLE_SIZE_SELECT", "200,300,400,500,600,800,1000,1200,1400,1600");
	}
	if (!defined("IMAGEFILTERS_RIPPLE_SIZE")) {
		define("IMAGEFILTERS_RIPPLE_SIZE", 400);
	}
	if ($_GET['size'].'' <> '') {
		$size = $_GET['size'];
		setcookie('imagefilters_ripple_size', $size, 0, MY_SESSION_PATH);
	} elseif ($_COOKIE['imagefilters_ripple_size'].'' <> '') {
		$size = $_COOKIE['imagefilters_ripple_size'];
	} else {
		$size = IMAGEFILTERS_RIPPLE_SIZE;
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="description" content="Powered by https://github.com/arahaya/ImageFilters.js">
<meta name="viewport" content="width=device-width, user-scalable=yes, initial-scale=1.0, maximum-scale=1">
<title>さざ波</title>
<script>
document.onkeydown = keyPress;
function keyPress( e ) {
	e = e || window.event;;
	if (e.keyCode == 27) {	// Esc
		window.close();
	} else {			// その他 (ファンクションキーなどを有効にするため)
		return true;
	}
	return false;
}
</script>
<script src="../scripts/jquery-1.8.3.js"></script>
<script src="../scripts/jquery.cookie.js"></script>
<script src="imagefilters/imagefilters.js"></script>
<script>
function trace() {
	try {
		console.log.apply(console, arguments);
	}
	catch (e) {
		try {
			console.log(Array.prototype.slice.apply(arguments));
		}
		catch (e) {
		}
	}
}
/**
 * this code is based on the flash version linked bellow
 * http://www.derschmale.com/2008/08/03/water-ripples-revisited-as3-only-version/
 */
function Rippler(source, strength, scale) {
	this._source = source;
	this._strength = strength;
	this._scaleInv = 1 / scale;
	// create the (downscaled) buffers and final (upscaled) image data, sizes depend on scale
	this._buffer1 = document.createElement('canvas').getContext('2d');
	this._buffer1.canvas.width = source.width * this._scaleInv;
	this._buffer1.canvas.height = source.height * this._scaleInv;
	this._buffer1.fillStyle = '#000000';
	this._buffer1.fillRect(0, 0, this._buffer1.canvas.width, this._buffer1.canvas.height);
	this._buffer2 = document.createElement('canvas').getContext('2d');
	this._buffer2.canvas.width = source.width * this._scaleInv;
	this._buffer2.canvas.height = source.height * this._scaleInv;
	this._defData = document.createElement('canvas').getContext('2d');
	this._defData.canvas.width = source.width;
	this._defData.canvas.height = source.height;
	this._defData.fillStyle = '#7f7f7f';
	this._defData.fillRect(0, 0, source.width, source.height);
	// Recalculate scale between the buffers and the final upscaled image to prevent roundoff errors.
	var correctedScaleX = this._defData.canvas.width / this._buffer1.canvas.width;
	var correctedScaleY = this._defData.canvas.height / this._buffer1.canvas.height;
	this._defData.scale(correctedScaleX, correctedScaleY);
	// Create a frame-based loop to update the ripples
	var self = this;
	this._interval = setInterval(function() {
		self._handleEnterFrame();
	}, 30);
}
Rippler.prototype.drawRipple = function(x, y, size, alpha) {
	var half = size >> 1; // We need half the size of the ripple
	var intensity = (alpha * 0xff & 0xff) * alpha; // The colour which will be drawn in the currently active buffer
	// calculate and draw the rectangle, having (x, y) in its centre
	var dx = (-half + x) * this._scaleInv;
	var dy = (-half + y) * this._scaleInv;
	var dw = size * this._scaleInv;
	var dh = dw;
	this._buffer1.fillStyle = 'rgb(0, 0, ' + intensity + ')';
	this._buffer1.fillRect(dx, dy, dw, dh);
};
Rippler.prototype.destroy = function() {
	clearInterval(this._interval);
	this._buffer1 = null;
	this._buffer2 = null;
	this._defData = null;
};
Rippler.prototype.onUpdate = function() {};
Rippler.prototype._handleEnterFrame = function() {
	// a temporary clone of buffer 2
	var buffer2Clone = this._buffer2.getImageData(0, 0, this._buffer1.canvas.width, this._buffer1.canvas.height);
	// buffer2 will contain an expanded version of buffer1
	var buffer1Image = this._buffer1.getImageData(0, 0, this._buffer1.canvas.width, this._buffer1.canvas.height);
	var buffer2Image = ImageFilters.ConvolutionFilter(buffer1Image, 3, 3, [0.5, 1, 0.5, 1, 0, 1, 0.5, 1, 0.5], 3, 0, false);
	// by substracting buffer2's old image, buffer2 will now be a ring
	buffer2Image = ImageFilters.BlendSubtract(buffer2Image, buffer2Clone, 0, 0);
	this._buffer2.putImageData(buffer2Image, 0, 0);
	// scale up and draw to the final displacement map, and apply it to the filter
	this._defData.drawImage(this._buffer2.canvas, 0, 0);
	var defImage = this._defData.getImageData(0, 0, this._defData.canvas.width, this._defData.canvas.height);
	defImage = ImageFilters.ColorTransformFilter(defImage, 1, 1, 1, 1, 128, 128, 128, 0);
	var result = ImageFilters.DisplacementMapFilter(this._source, defImage, 0, 0, 2, 2, this._strength, this._strength, 2);
	// switch buffers 1 and 2
	this._switchBuffers();
	this.onUpdate(result);
};
Rippler.prototype._switchBuffers = function() {
	var temp = this._buffer1;
	this._buffer1 = this._buffer2;
	this._buffer2 = temp;
};
function main(img) {
	var $canvas = $('#c');
	$canvas[0].width  = img.width;
	$canvas[0].height = img.height;
	var context = $canvas[0].getContext('2d');
	context.drawImage(img, 0, 0);
	var target = context.getImageData(0, 0, img.width, img.height);
	var rippler = new Rippler(target, 60, 8);
	rippler.onUpdate = function(target) {
		context.putImageData(target, 0, 0);
	};
	// mousemove
	$canvas.bind('mousemove touchmove', function(e) {
		var mouseX = e.pageX - $canvas.offset().left;
		var mouseY = e.pageY - $canvas.offset().top;
		rippler.drawRipple(mouseX, mouseY, 8, 1);
		return false;
	});
}
$(function() {
	$('<img style="width:<?= $size ?>px;" />').load(function() {
		main(this);
	}).attr("src", "<?= $getimg ?>");
});
</script>
<script>
function Selection(id) {
	seldata = $("#"+id).val();
	$.cookie('imagefilters_ripple_'+id,seldata,{path:'<?= MY_SESSION_PATH ?>', expires:30});
	window.location.href = "?img=<?= $_GET['img'] ?>&"+id+"="+seldata;
}
</script>
</head>
<body>
<div id="header" style="font-size:12px;">
<span style="font-weight:bold;margin-right:20px;">さざ波</span>サイズ(横幅):
<select id="size" onchange="Selection('size')">
<?php
	$optary = explode(",", IMAGEFILTERS_RIPPLE_SIZE_SELECT);
	foreach ($optary as $opt) {
?>
	<option value="<?= $opt ?>"<?= $opt == $size ? " selected" : "" ?>><?= $opt ?> px
<?php
	}
?>
</select>
</div>
<canvas id="c" style="width:<?= $size ?>px;"></canvas>
<p style="font-size:12px;">Move the mouse over the image!</p>
</body>
</html>
