/* WCEFileSystemView.java --
   Copyright (C) 2006  Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class WCEFileSystemView extends FileSystemView {

	private static final String NEW_FOLDER_NAME = "NewFolder";

	public boolean isRoot(File f) {
		return "\\".equals(f.getAbsolutePath());
	}
	
	public String getSystemDisplayName(File f) {
		return f.getName();
	}
	
	public String getSystemTypeDescription(File f) {
		// ToDo: 
		return null;
	}
	
	public Icon getSystemIcon(File f) {
		// ToDo: 
		return null;
	}
	
	public boolean isParent(File folder,
                       		File file) {
		return file.getParent().equals(folder);
	}
	
	public boolean isFileSystem(File f) {
		return true;
	}
	
	public File createNewFolder(File containingDir) throws IOException {
		String abspath = containingDir.getAbsolutePath();
		String filename;
		if (abspath.endsWith(File.separator)) {
			filename = abspath + File.separator + NEW_FOLDER_NAME;
		} else {
			filename = abspath + NEW_FOLDER_NAME;
		}

		int count = 0;
		File f = null;
		while (f == null) {
			String full = filename;
			if (count > 0)
				full += "" + (count++);
			f = new File(full);
			if (f.exists()) {
				count++;
				f = null;
			}
		}
		f.mkdir();
		return f;
	}
}

