#pragma once

#include <windows.h>
#include <stdio.h>

/**
 * f[^ubN
 */
struct DataBlock {
	int size;
	char* data;

	DataBlock() : size(0), data(NULL) {
	}

	~DataBlock() {
		free(data);
	}
};

// OQ
struct DecoderInfo;

/**
 * GIFFileNX
 * gnu.javax.imageio.gif.GIFFile̓eɊÂ쐬Ă
 */
class GIFFile {
private:
	// "NETSCAPE2.0" - identifier
	static const unsigned char nsBlock[];

	/**
	 * Block identifiers
	 */
	static const int EXTENSION = 0x21;
	static const int LOCAL = 0x2C;
	static const int TERMINATOR = 0x3B;

	/**
	 * Extension block types
	 */
	static const int EXTENSION_COMMENT = 254;
	static const int EXTENSION_GCONTROL = 249; 
	static const int EXTENSION_APPLICATION = 255;

	/**
	 * Parent image
	 */
	GIFFile* parent;

	/**
	 * Image position and dimensions (images may be partial)
	 */
	int x, y, width, height;

	/**
	 * Global dimensions
	 */
	int globalWidth, globalHeight;

	/**
	 * Background color index.
	 */
	unsigned char bgIndex;

	/**
	 * Number of colors
	 */
	int nColors;

	/**
	 * Global palette, if any
	 */
	unsigned char* globalPalette;

	/**
	 * Any
	 */
	bool hasGlobalColorMap;

	/**
	 * Local palette, if any (used if available)
	 */
	unsigned char* localPalette;

	/**
	 * Interlaced GIF or not?
	 */
	bool interlaced;

	/**
	 * Has transparency?
	 */
	bool hasTransparency;
  
	/**
	 * disposal method (animations)
	 */
    int disposalMethod;

	/**
     * Transparent index;
     */
	int transparentIndex;

	/**
	 * Frame delay in 100ths of a second ( centiseconds, metrically )
	 */
	int duration;

	/**
	 * Netscape animation extension
	 */
	bool isLooped;

	/** Number of loopCount, 0 = infinite */
	int loopCount;

	/**
	 * Decoded image
	 */
	BYTE* raster;

	/**
	 * Additional frames if it's an animated GIF.
	 */
	GIFFile** animationFrames;
	int animationFrameCount;

	bool valid;

	bool readSignature(FILE* file);
	bool readExtension(FILE* file);
	
	bool readLocal(FILE* file);
	bool loadImage(FILE* file);

	DataBlock* readData(FILE* file);

	bool decodeRaster(int initialCodeSize, DataBlock* compressedData, BYTE* pBits);
	bool deinterlace(BYTE* pBits);

	int getBits(int c, DecoderInfo& info);

	inline DWORD indexToARGB(unsigned char* palette, int index) {
		unsigned char* color = &palette[index * 3];
		DWORD pixel = (DWORD) ((color[0] << 16) & 0xff0000) | ((color[1] << 8) & 0xff00)| (color[2] & 0xff);
		if (! hasTransparentColor() || index != this->transparentIndex) {
			pixel |= 0xff000000;
		}
		return pixel;
	}

	inline WORD indexToRGB565(unsigned char* palette, int index) {
		unsigned char* color = &palette[index * 3];
		WORD pixel = (WORD) ((color[0] << 8) & 0xf800) | ((color[1] << 3) & 0x07e0) | ((color[2] >> 3) & 0x001f);
		return pixel;
	}

	/**
	 * Aj[VGIF̑2t[ȍ~\z
	 */
	GIFFile(GIFFile* parent, FILE* file, int c);

public:
	GIFFile(_TCHAR* filename);
	~GIFFile();

	/**
	 * ̉摜߂ꂽԂ
	 */
	inline bool isValid() { return this->valid; }

	/**
	 * Aj[Vp̌㑱t[𓾂
	 */
	inline int getAnimationFrameCount() { return this->animationFrameCount; }

	/**
	 * 㑱t[擾
	 */
	inline GIFFile* getAnimationFrame(int frame) { return this->animationFrames[frame]; }

	/**
	 * 1ڂ̃t[擾
	 */
	inline GIFFile* getParent() { return this->parent; }

	inline int getGlobalWidth() { return this->globalWidth; }
	inline int getGlobalHeight() { return this->globalHeight; }


	inline int getX() { return this->x; }
	inline int getY() { return this->y; }

	/**
	 * C[W̕Ԃ
	 */
	inline int getWidth()	{ return this->width; }

	/**
	 * C[W̍Ԃ
	 */
	inline int getHeight()	{ return this->height; }

	/**
	 * \ԂԂ
	 * Pʂ10ms
	 */
	inline int getDuration() { return this->duration; }

	/**
	 * [v񐔂Ԃ
	 */
	inline int getLoopCount() { return this->isLooped ? this->loopCount : -1; }

	/**
	 * FT|[gĂ邩Ԃ
	 */
	inline bool hasTransparentColor() { return this->hasTransparency; }

	/**
	 * FԂ
	 */
	COLORREF getTransparentColor();
	
	/**
	 * Disposal method for animation.
	 */
	static const int DISPOSAL_MODE_NOT_SPECIFIED               = 0;
	static const int DISPOSAL_MODE_DO_NOT_DISPOSE              = 1;
	static const int DISPOSAL_MODE_RESTORE_TO_BACKGROUND_COLOR = 2;
	static const int DISPOSAL_MODE_RESTORE_TO_PREVIOUS         = 3; 

	inline int getDisposalMethod() { return this->disposalMethod; }

	/**
	 * X^f[^ԂB
	 * X^f[^ getWidth() * getHeight() * sizeof(BYTE)  BYTE zł
	 * evf̃J[CfbNXi[Ă
	 */
	inline BYTE* getRaster() { return this->raster; }


	/**
	 * w肳ꂽobt@ ARGB `ŉ摜]
	 */
	void draw(DWORD* dest);

	/**
	 * w肳ꂽobt@RGB565`ŉ摜]
	 */
	void drawRGB565(WORD* dest);

};