/* WCEMenuPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;

public class WCEMenuPeer extends WCEMenuItemPeer implements MenuPeer {
	/**
	 * eMenuBaȑꍇWCEMenuBarPeerB
	 * eMenuBarȊȌꍇnullƂȂB
	 */
	private WCEMenuBarPeer menuBarPeer;
	
	/**
	 * lCeBũj[nh
	 */
	private int menuHandle;
	
	WCEMenuPeer(Menu menu) {
		super(menu);
	}

	/**
	 * lCeBuj[쐬Aj[nhԂB
	 */
	protected native int createNativeMenu();
	
	/**
	 * WCEMenuBarPeerݒ肷B
	 * ̃CX^X́Aj[o[ɒǉ邱ƂɂȂB
	 */
	void setMenuBarPeer(WCEMenuBarPeer menuBarPeer) {
		this.menuBarPeer = menuBarPeer;
	}
	
	/**
	 * ej[o[̏ꍇApeerԂ
	 * ej[o[Ŗꍇ́AnullԂB
	 */
	WCEMenuBarPeer getMenuBarPeer() {
		return this.menuBarPeer;
	}
	
	/**
	 * w肳ꂽj[nhɑ΂Ďgǉ
	 */
	protected void addTo(int parentMenuHandle, String label) {
		appendNative(parentMenuHandle, getMenuHandle(), label);
	}

	/**
	 * MenuPeerɑΉlCeBuj[jB
	 */
	public void dispose() {
		if (this.menuHandle != 0) {
			if (this.menuBarPeer != null) {
				// j[o[ɂꍇ
				this.menuBarPeer.deleteNativeMenuByHandle(
									this.menuBarPeer.getMenuBarWindowHandle(),
									this.menuHandle);
			} else {
				// j[o[ɂȂꍇMenuItemPeer
				// s킹
				super.dispose();
			}
			// gj
			destroyNativeMenu(this.menuHandle);
		}

		this.menuHandle = 0;
		this.menuBarPeer = null;
	}

	/**
	 * MenuPeerɑΉlCeBuj[j
	 */
	private native void destroyNativeMenu(int handle);
	
	/**
	 * w肳ꂽj[nhɑ΂Ďgǉ
	 */
	private native void appendNative(int parentMenuHandle,
									 int menuHandle,
									 String label);
	
	/**
	 * lCeBuj[nhԂB
	 */
	int getMenuHandle() {
		if (this.menuHandle == 0) {
			this.menuHandle = createNativeMenu();
		}
		return this.menuHandle;
	}
	
	/**
	 * w肳ꂽMenuItemǉ
	 */
	public void addItem (MenuItem item) {
		WCEMenuItemPeer menuItemPeer = (WCEMenuItemPeer) item.getPeer();
		menuItemPeer.setMenuPeer(this);
		menuItemPeer.addTo(getMenuHandle(), item.getLabel());
	}
	
	/**
	 * w肳ꂽʒuɂ郁j[폜
	 */
	public void delItem (int index) {
		deleteNativeMenuItem(getMenuHandle(), index);
	}
	
	/**
	 * w肳ꂽCfbNXʒuɂ郁j[ACe
	 * 폜
	 */
	private native void deleteNativeMenuItem(int menuHandle,
											 int index);
	
  public void addSeparator()
  {
    // FIXME: implement
  }
}
