/* WCETextFieldPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextFieldPeer;

public class WCETextFieldPeer extends WCETextComponentPeer implements TextFieldPeer {
	WCETextFieldPeer(TextField textField) {
		super(textField);
		setText(textField.getText());
		setEditable(textField.isEditable());
		setEchoChar(textField.getEchoChar());
	}
	
	protected native int createNative(int parentWindowHandle, int x, int y, int width, int height);

	public Dimension minimumSize(int len) {
		return getMinimumSize(len);
	}
	
	public Dimension preferredSize(int len) {
		return getPreferredSize(len);
	}
	
	public Dimension getMinimumSize(int len) {
		return getPreferredSize(len);
	}
	
	public Dimension getPreferredSize(int len) {
		return getNativePreferredSize(getWindowHandle(), len);
	}
	
	private native Dimension getNativePreferredSize(int windowHandle, int len);
	
	
	public void setEchoChar(char echo_char) {
		setNativeEchoChar(getWindowHandle(), echo_char);
	}
	
	private native void setNativeEchoChar(int windowHandle, char echoChar);
	
	public void setEchoCharacter(char echo_char) {
		setEchoChar(echo_char);
	}

	public void handleEvent(AWTEvent e) {
		if (e.getID() == KeyEvent.KEY_PRESSED) {
			KeyEvent ke = (KeyEvent) e;

			if (!ke.isConsumed () && ke.getKeyCode() == KeyEvent.VK_ENTER) {
				// EnterL[ꂽꍇActionEvent𔭐
				queue.postEvent(
					new ActionEvent(e.getSource(),
									ActionEvent.ACTION_PERFORMED,
									getText(),
									ke.getWhen(),
									ke.getModifiersEx()));
			}
		}
		super.handleEvent(e);
	}
}
