﻿using System;
using System.Collections.Generic;
using System.Linq;
using Irony.Interpreter;
using System.Windows.Forms;

namespace myBuiltInMethod
{
    
    public class ScriptBuiltInMethod
    {

        private BrowserScriptInterfaces weblib = null;
        private FormScriptInterfaces formlib = null;

        public ScriptBuiltInMethod()
        {
        }

        //アプリから呼び出す。
        public void Init(BrowserScriptInterfaces browserinterfaces , FormScriptInterfaces formInterfases)
        {
            weblib = browserinterfaces;
            formlib = formInterfases;
        }


        #region　ブラウザ関連
        //**************************************************************
        //ブラウザ関連
        //**************************************************************

        public object ClickXpath(ScriptThread thread, object[] args)
        {
            if(args.Length == 1)
            {
                weblib.ClickXpath(args[0].ToString());
            }
            else if(args.Length == 2)
            {
                weblib.ClickXpath(args[0].ToString(), int.Parse(args[1].ToString()) );
            }
           
            return null;
        }



        public object Navigate(ScriptThread thread, object[] args)
        {
            var url = args[0].ToString();
            weblib.Navigate(url);
            return weblib.getURL();
        }


        public object GetTextContents(ScriptThread thread, object[] args)
        {
            var XPATH = args[0].ToString();
            return weblib.GetTextContents(XPATH);
        }

        #endregion

        #region　フォーム関連
        //**************************************************************
        //フォーム関連
        //**************************************************************
        public object GetFormControlDictionary(ScriptThread thread , object[] args)
        {
            return formlib.GetFormControlDictionary();
        }


        public object PerformClick(ScriptThread thread , object[] args)
        {
            var menu = args[0] as ToolStripItem;
            if (menu != null)
            {
                menu.PerformClick();
                return null;
            }

            var button = args[0] as Button;
            if (button != null)
            {
                button.PerformClick();
                return null;
            }

            return null;
        }


        public object msgbox(ScriptThread thread , object[] args)
        {
            string text = string.Empty;
            switch (args.Length)
            {
                case 1:
                    text = string.Empty + args[0]; //compact and safe conversion ToString()
                    break;
                case 0:
                    break;
                default:
                    text = string.Join(" " , args);
                    break;
            }
            MessageBox.Show(text);
            return null;
        }



        #endregion

        #region　その他

        //**************************************************************
        //その他
        //**************************************************************

        public object Dic2ValArr(ScriptThread thread , object[] args)
        {
            var dic = args[0] as Dictionary<string , object>;
            if (dic != null )
            {
                var ar = dic.Values.ToArray();
                return (object)ar;
            }
            return null;
        }

        public object Dic2KeyArr(ScriptThread thread , object[] arg)
        {
            var dic = arg[0] as Dictionary<string , object>;
            if (dic != null)
            {
                var ar = dic.Keys.ToArray();
                return (object)ar;
            }
            return null;
        }

        /// <summary>
        /// ディクショナリーを2次元配列にする
        /// </summary>
        /// <param name="thread"></param>
        /// <param name="args"></param>
        /// <returns>object ar[2][...] 　[0]キー、[1]オブジェクト</returns>
        public object Dic2Arr(ScriptThread thread , object[] arg)
        {
            var dic = arg[0] as Dictionary<string , object>;

            if (dic == null)
            {
                MessageBox.Show("dic Null");
                return null;
            }

            object[][] ar = new object[2][] ;
            ar[0] = dic.Keys.ToArray<object>() ;
            ar[1] = dic.Values.ToArray<object>() ;
            return ar;
        }


        //**************************************************************
        //ファイル入出力
        //**************************************************************
        public object ReadFile(ScriptThread thread , object[] args)
        {
            var filepath = args[0].ToString();
            string res = "";

            if (System.IO.File.Exists(filepath))
            {
                try
                {
                    res = System.IO.File.ReadAllText(filepath);
                }
                catch (Exception ex)
                {
                    MessageBox.Show("ファイル読み込み失敗しました。" + Environment.NewLine + ex.Message);
                    res = "";
                }
            }
            return res;
        }

        public object WriteFile(ScriptThread thread , object[] args)
        {
            string filepath;
            string text;
            bool res = false;

            //引数チェック
            try
            {
                filepath = args[0].ToString();
                text = args[1].ToString();
            }
            catch (Exception ex)
            {
                MessageBox.Show("指定が正しくありません。" + Environment.NewLine + ex.Message);
                return false;
            }

            //******************************
            try
            {
                System.IO.File.WriteAllText(filepath , text);
                res = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show("ファイル書き込み失敗しました。" + Environment.NewLine + ex.Message);
                res = false;
            }

            return res;
        }


        //**************************************************************
        //文字列操作
        //**************************************************************
        public object Substring(ScriptThread thread, object[] args)
        {
            var str = args[0].ToString();
            var start = int.Parse(args[1].ToString());
            var cnt = int.Parse(args[2].ToString());
            return str.Substring(start, cnt);

        }


        #endregion
    }
}
