﻿using System;
using System.Linq;
using System.Windows.Forms;
using Gecko;
using System.Collections.Generic;


namespace myBuiltInMethod
{

    public class FormScriptInterfaces
    {
        public Dictionary<string , object> FormControlDic;

        public FormScriptInterfaces()
        {
            FormControlDic = new Dictionary<string , object>();
        }


        //**********************************************************************
        //フォーム側から呼び出しする。
        //**********************************************************************
        #region Add Control,StripItem

        public void Add(string key , Control control)
        {
            //すでに登録済みのとき、いったん削除する。
            if (FormControlDic.ContainsKey(key))
                FormControlDic.Remove(key);
            FormControlDic.Add(key , control);
        }

        public void Add(string key, ToolStripItem stripItem)
        {
            //すでに登録済みのとき、いったん削除する。
            if (FormControlDic.ContainsKey(key))
                FormControlDic.Remove(key);
            FormControlDic.Add(key, stripItem);
        }

        public void Add(Control control)
        {
            var key = control.Name;
            if (key == null)
                throw(new ArgumentException("コントロールに名前がありません") ) ;

            Add(key, control);
        }

        public void Add(ToolStripItem stripItem)
        {
            var key = stripItem.Text;
            if (key == null)
                throw (new ArgumentException("コントロールに名前がありません"));

             Add(key ,  stripItem);

        }

        #endregion


        //**********************************************************************
        //scriptのbuiltinMethodから呼び出す。
        //**********************************************************************
        public string GetText(string controlName)
        {
            //存在しないときは""を返す
            if (FormControlDic.ContainsKey(controlName) == false)
                return "";

            if (FormControlDic[controlName].GetType() == typeof(Control))
                return ((Control)FormControlDic[controlName]).Text;

            //ToolStripItemは、Control派生ではありません。
            if (FormControlDic[controlName].GetType() == typeof(ToolStripItem))
                return ((ToolStripItem)FormControlDic[controlName]).Text;

            //コントロールでないものがセットされていたら、""を返す
            return "";
        }

        public bool SetText(string controlName , string Text)
        {
            //存在しないときは""を返す
            if (FormControlDic.ContainsKey(controlName) == false)
                return false;

            if (FormControlDic[controlName].GetType() == typeof(Control))
            {
                ((Control)FormControlDic[controlName]).Text = Text;
                return true;
            }

            //ToolStripItemは、Control派生ではありません。
            if (FormControlDic[controlName].GetType() == typeof(ToolStripItem))
            {
                ((ToolStripItem)FormControlDic[controlName]).Text = Text;
                return true;
            }
            //コントロールでないものがセットされていたら、""を返す
            return false;
        }



        public object GetCont(string key)
        {
            //存在しないときはｎｕｌｌを返す
            if (FormControlDic.ContainsKey(key) == false)
                return null;
            return FormControlDic[key];
        }


        //BuiltInMethodからアクセスする
        public Dictionary<string , object> GetFormControlDictionary()
        {
            return FormControlDic;
        }





    }//class

}