﻿#region License
/* **********************************************************************************
 * Copyright (c) Roman Ivantsov
 * This source code is subject to terms and conditions of the MIT License
 * for Irony. A copy of the license can be found in the License.txt file
 * at the root of this distribution. 
 * By using this source code in any fashion, you are agreeing to be bound by the terms of the 
 * MIT License.
 * You must not remove this notice from this software.
 * **********************************************************************************/
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Irony.Ast;
using Irony.Parsing;

namespace Irony.Interpreter.Ast
{

    public class ReturnNode : AstNode
    {
//        object result = null;
        resultWithReturnType result;

        public override void Init(AstContext context, ParseTreeNode treeNode)
        {
            base.Init(context, treeNode);
            
            //treenodeのchildnodeが２つあるとき、返値用のASTノードを追加
            if(treeNode.ChildNodes != null && treeNode.ChildNodes.Count == 2)
            {
                AddChild(NodeUseType.ValueRead, "returnValue", treeNode.ChildNodes[1]);
                AsString = "Return[" + treeNode.ChildNodes[0].FindTokenAndGetText() + "]";
            }
            else
            {
                //AddChild(NodeUseType.ValueRead , "NullreturnValue" , null);
                AsString = "Return[null]";
            }
        }

        protected override object DoEvaluate(ScriptThread thread)
        {
            thread.CurrentNode = this;  //standard prolog

            //返値用のASTノードがあるなら
            if (thread.CurrentNode.ChildNodes != null && thread.CurrentNode.ChildNodes.Count == 1)
            {
                result = new resultWithReturnType(thread.CurrentNode.ChildNodes[0].Evaluate(thread));
            }
            else
            {
                result = new resultWithReturnType(null);
            }

            thread.CurrentNode = Parent; //standard epilog
            return result;
        }//method

        ////// TODO: implement handling list/dict parameter tails (Scheme, Python, etc)
        ////private object EvaluateAfter(ScriptThread thread)
        ////{
        ////    return null;
        ////}
    }//class

}//namespace
