﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace myScriptableBrowser
{
    public partial class Form1 : Form
    {
        //参考URL
        //http://blog.witchcraft-works.net/article/118152910.html
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {

            if(keyData == (Keys.A | Keys.Control))
            {
                var text = getActiveTextbox();
                if(text != null)
                {
                    text.SelectAll();
                }
            }
            return base.ProcessCmdKey(ref msg, keyData);
        }

        /// <summary>
        /// アクティブなコントロールがテキストボックスか調べる
        /// </summary>
        /// <returns></returns>
        private TextBox getActiveTextbox()
        {
            ContainerControl containerControl;

            if(this.ActiveControl is TextBox)
            {
                return (TextBox)this.ActiveControl;
            }
            else if(this.ActiveControl is ContainerControl)
            {
                containerControl = (ContainerControl)this.ActiveControl;
                while(containerControl.ActiveControl is ContainerControl)
                {
                    containerControl = containerControl.ActiveControl as ContainerControl;
                }

                if(containerControl.ActiveControl is TextBox)
                {
                    return (TextBox)containerControl.ActiveControl;
                }
            }
            return null;
        }

    }
}
