/*
 * Decompiled with CFR 0.152.
 */
package org.yanroncha.n3.resource.xml.node;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

class Html2N3Article {
    private static final String BASIC_INTENTS = "    ";
    private String src;
    private String last_t;
    private ParserDelegator parser = new ParserDelegator();
    private boolean compress = false;
    private StringBuilder indent = null;
    private StringWriter sw = null;
    private PrintWriter out = null;
    private boolean open = false;
    private String line_break = "";
    private ArrayList<Integer> stat_stack;
    private int acnt;
    private int na_cnt;
    private int ta_cnt;
    private ConvertedCallback cb;

    public Html2N3Article(String string, boolean bl, ConvertedCallback convertedCallback) {
        this.src = string;
        this.compress = bl;
        this.line_break = bl ? "" : "\n";
        this.stat_stack = new ArrayList();
        this.cb = convertedCallback;
    }

    public void invoke() {
        this.sw = new StringWriter();
        this.out = new PrintWriter(this.sw);
        this.indent = new StringBuilder();
        this.open = false;
        this.ta_cnt = 0;
        this.na_cnt = 0;
        this.acnt = 0;
        this.stat_stack.clear();
        StringReader stringReader = new StringReader(this.src);
        try {
            this.out.printf("[%s", this.line_break);
            this.incIndent();
            this.parser.parse(stringReader, new N3HtmlParserCallback(), true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getIndent() {
        return this.compress ? "" : this.indent.toString();
    }

    private void incIndent() {
        this.indent.append(BASIC_INTENTS);
    }

    private void decIndent() {
        try {
            this.indent.delete(0, BASIC_INTENTS.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.out.printf(stringIndexOutOfBoundsException.toString(), new Object[0]);
        }
    }

    public static interface ConvertedCallback {
        public void converted(String var1, boolean var2);
    }

    class N3HtmlParserCallback
    extends HTMLEditorKit.ParserCallback {
        N3HtmlParserCallback() {
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (!(HTML.Tag.HTML.equals(tag) || HTML.Tag.HEAD.equals(tag) || HTML.Tag.BODY.equals(tag))) {
                this.openTag(tag.toString(), mutableAttributeSet);
            }
            super.handleStartTag(tag, mutableAttributeSet, n);
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int n) {
            if (!(HTML.Tag.HTML.equals(tag) || HTML.Tag.HEAD.equals(tag) || HTML.Tag.BODY.equals(tag))) {
                this.closeTag(tag.toString());
            }
            super.handleEndTag(tag, n);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            this.openTag(tag.toString(), mutableAttributeSet);
            this.closeTag(tag.toString());
            super.handleSimpleTag(tag, mutableAttributeSet, n);
        }

        @Override
        public void handleText(char[] cArray, int n) {
            String string = new String(cArray).replaceAll("\\\\", "\\\\\\\\");
            string = string.replaceAll("\\\"", "\\\\\\\"");
            string = string.replaceAll("\\'", "\\\\\\'");
            if (Html2N3Article.this.open) {
                Html2N3Article.this.out.printf(",%s", Html2N3Article.this.line_break);
                Html2N3Article.this.out.printf("%st:\"%s\"", Html2N3Article.this.getIndent(), string);
            } else {
                if (Html2N3Article.this.acnt > 0) {
                    Html2N3Article.this.out.printf(",%s", Html2N3Article.this.line_break);
                }
                Html2N3Article.this.out.printf("%s{%s", Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
                Html2N3Article.this.incIndent();
                Html2N3Article.this.out.printf("%stype:\"text\",%s", Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
                Html2N3Article.this.out.printf("%stext:\"%s\"%s", Html2N3Article.this.getIndent(), string, Html2N3Article.this.line_break);
                Html2N3Article.this.decIndent();
                Html2N3Article.this.out.printf("%s}", Html2N3Article.this.getIndent());
            }
            Html2N3Article.this.acnt++;
            Html2N3Article.this.ta_cnt++;
            Html2N3Article.this.last_t = string;
            super.handleText(cArray, n);
        }

        @Override
        public void handleEndOfLineString(String string) {
            String string2;
            boolean bl;
            Html2N3Article.this.decIndent();
            Html2N3Article.this.out.printf("%s]", Html2N3Article.this.line_break);
            Html2N3Article.this.out.flush();
            super.handleEndOfLineString(string);
            if (Html2N3Article.this.na_cnt == 0 && Html2N3Article.this.ta_cnt <= 1) {
                bl = true;
                string2 = "\"" + Html2N3Article.this.last_t + "\"";
            } else {
                bl = false;
                string2 = Html2N3Article.this.sw.toString();
            }
            Html2N3Article.this.cb.converted(string2, bl);
        }

        private void openTag(String string, MutableAttributeSet mutableAttributeSet) {
            if (Html2N3Article.this.open) {
                Html2N3Article.this.out.printf(",%s%s_:[%s", Html2N3Article.this.line_break, Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
                Html2N3Article.this.incIndent();
                Html2N3Article.this.stat_stack.add(Html2N3Article.this.acnt);
                Html2N3Article.this.acnt = 0;
            } else {
                Html2N3Article.this.open = true;
                if (Html2N3Article.this.acnt > 0) {
                    Html2N3Article.this.out.printf(",%s", Html2N3Article.this.line_break);
                } else {
                    Html2N3Article.this.out.print(Html2N3Article.this.line_break);
                }
            }
            Html2N3Article.this.out.printf("%s{%s", Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
            Html2N3Article.this.incIndent();
            Html2N3Article.this.out.printf("%stype:\"*\",%s", Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
            Html2N3Article.this.out.printf("%s$:\"%s\"", Html2N3Article.this.getIndent(), string);
            if (mutableAttributeSet.getAttributeCount() > 0) {
                Html2N3Article.this.out.printf(",%s", Html2N3Article.this.line_break);
                Html2N3Article.this.out.printf("%sa:{%s", Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
                Html2N3Article.this.incIndent();
                Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    if (n > 0) {
                        Html2N3Article.this.out.printf(",%s", Html2N3Article.this.line_break);
                    }
                    Html2N3Article.this.out.printf("%s%s:\"%s\"", Html2N3Article.this.getIndent(), obj.toString(), mutableAttributeSet.getAttribute(obj));
                    ++n;
                }
                Html2N3Article.this.out.print(Html2N3Article.this.line_break);
                Html2N3Article.this.decIndent();
                Html2N3Article.this.out.printf("%s}", Html2N3Article.this.getIndent());
            }
            Html2N3Article.this.acnt++;
            Html2N3Article.this.na_cnt++;
        }

        private void closeTag(String string) {
            Html2N3Article.this.decIndent();
            if (Html2N3Article.this.open) {
                Html2N3Article.this.out.printf("%s%s}", Html2N3Article.this.line_break, Html2N3Article.this.getIndent());
            } else {
                int n = Html2N3Article.this.stat_stack.size();
                if (n > 0) {
                    Html2N3Article.this.acnt = (Integer)Html2N3Article.this.stat_stack.remove(n - 1);
                }
                Html2N3Article.this.out.printf("%s%s]%s", Html2N3Article.this.line_break, Html2N3Article.this.getIndent(), Html2N3Article.this.line_break);
                Html2N3Article.this.decIndent();
                Html2N3Article.this.out.printf("%s}", Html2N3Article.this.getIndent());
            }
            Html2N3Article.this.open = false;
        }
    }
}

