/*
 * Decompiled with CFR 0.152.
 */
package jp.nanosan.memocalc.memocalc_gui;

import jp.nanosan.memocalc.memocalc_gui.MemoCalc_Comment_Check;
import jp.nanosan.memocalc.memocalc_gui.MemoCalc_Main;
import jp.nanosan.memocalc.memocalc_lib.Calc_Main;
import jp.nanosan.memocalc.memocalc_lib.Color_Manager;
import jp.nanosan.memocalc.memocalc_lib.Font_Manager;
import jp.nanosan.memocalc.memocalc_lib.Read_Line;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class MemoCalc_Text {
    private static MemoCalc_Text text_inst = null;
    public SourceViewer viewer;
    private TextViewerUndoManager undo_man = new TextViewerUndoManager(100);

    private MemoCalc_Text(Composite parent) {
        this.viewer = new SourceViewer(parent, null, 2818);
        this.set_viewer();
    }

    public static MemoCalc_Text get_inst(Composite parent) {
        if (text_inst == null) {
            text_inst = new MemoCalc_Text(parent);
        }
        return text_inst;
    }

    public static MemoCalc_Text get_inst() {
        return text_inst;
    }

    private void set_viewer() {
        this.viewer.getTextWidget().setFont(Font_Manager.get("text_font"));
        Document doc = new Document();
        FastPartitioner partitioner = new FastPartitioner(new MemoCalc_Partition_Scanner(), new String[]{"__memocalc_comment", "__memocalc_error"});
        partitioner.connect((IDocument)doc);
        doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.viewer.configure(new MemoCalc_Configuration());
        this.viewer.setDocument((IDocument)doc);
        this.viewer.setUndoManager(this.undo_man);
        this.undo_man.connect(this.viewer);
        this.viewer.getTextWidget().setFocus();
        this.viewer.getTextWidget().setTabs(4);
        this.viewer.getTextWidget().setIndent(5);
        this.viewer.getTextWidget().setLineSpacing(1);
        Enter_Key_Listener vk = new Enter_Key_Listener();
        this.viewer.getTextWidget().addVerifyKeyListener(vk);
    }

    private class Enter_Key_Listener
    implements VerifyKeyListener {
        private Enter_Key_Listener() {
        }

        public void verifyKey(VerifyEvent e) {
            if (e.character == '\r') {
                this.enter_key_proc(e);
            }
        }

        private void enter_key_proc(VerifyEvent e) {
            Calc_Main calc_inst = Calc_Main.get_inst();
            StyledText text = MemoCalc_Text.this.viewer.getTextWidget();
            String delim = text.getLineDelimiter();
            Read_Line rl = Read_Line.get_inst();
            String str = rl.get_line_string(text);
            if (str == null) {
                e.doit = true;
            } else if (str.equals("exit")) {
                MemoCalc_Main.get_inst().action_close.run();
                e.doit = false;
            } else {
                String str0 = MemoCalc_Comment_Check.comment_out(str);
                int line_head = rl.get_line_head_offset(text);
                text.setCaretOffset(line_head + str.length());
                String str1 = calc_inst.parse(str0);
                if (str1.equals("")) {
                    e.doit = true;
                } else {
                    String str2 = " " + str1;
                    text.insert(String.valueOf(delim) + str2);
                    text.setCaretOffset(text.getCaretOffset() + delim.length() + str2.length());
                    e.doit = true;
                    if (!str1.contains("error")) {
                        text.setStyleRange(new StyleRange(line_head + str.length() + delim.length(), str2.length(), Color_Manager.get("mediumblue"), null));
                    }
                }
                if (!(str1.contains("error") | str1.equals(""))) {
                    MemoCalc_Main.get_inst().setStatus("Last answer = " + String.valueOf(calc_inst.last_answer) + " ( answer of  " + str0 + "  )");
                }
            }
        }
    }

    private class MemoCalc_Configuration
    extends SourceViewerConfiguration {
        private MemoCalc_Configuration() {
        }

        public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contenttype) {
            return null;
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = new PresentationReconciler();
            Color darkviolet = Color_Manager.get("darkviolet");
            Color tomato = Color_Manager.get("tomato");
            DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer(new Single_Token_Scanner(new TextAttribute(darkviolet)));
            reconciler.setDamager(commentDR, "__memocalc_comment");
            reconciler.setRepairer(commentDR, "__memocalc_comment");
            DefaultDamagerRepairer errorDR = new DefaultDamagerRepairer(new Single_Token_Scanner(new TextAttribute(tomato)));
            reconciler.setDamager(errorDR, "__memocalc_error");
            reconciler.setRepairer(errorDR, "__memocalc_error");
            return reconciler;
        }
    }

    private class MemoCalc_Partition_Scanner
    extends RuleBasedPartitionScanner {
        public static final String MEMOCALC_COMMENT = "__memocalc_comment";
        public static final String MEMOCALC_ERROR = "__memocalc_error";

        public MemoCalc_Partition_Scanner() {
            IPredicateRule[] rules = new IPredicateRule[3];
            Token comment = new Token(MEMOCALC_COMMENT);
            rules[0] = new EndOfLineRule("#", comment);
            rules[1] = new EndOfLineRule("//", comment);
            Token error = new Token(MEMOCALC_ERROR);
            rules[2] = new EndOfLineRule("error:", error);
            this.setPredicateRules(rules);
        }
    }

    private class Single_Token_Scanner
    extends BufferedRuleBasedScanner {
        public Single_Token_Scanner(TextAttribute attribute) {
            this.setDefaultReturnToken(new Token(attribute));
        }
    }
}

