/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.Hashtable;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;

public class PnutsObjectInputStream
extends ObjectInputStream {
    private Context context;
    private static Hashtable primitives = new Hashtable();

    public PnutsObjectInputStream(InputStream in, Context context) throws IOException, StreamCorruptedException {
        super(in);
        this.context = context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class clazz;
        String name = objectStreamClass.getName();
        if (!name.startsWith("[")) {
            Class type = (Class)primitives.get(name);
            if (type != null) {
                return type;
            }
            return Pnuts.loadClass((String)name, (Context)this.context);
        }
        int i = 1;
        while (name.charAt(i) == '[') {
            ++i;
        }
        if (name.charAt(i) == 'L') {
            clazz = Pnuts.loadClass((String)name.substring(i + 1, name.length() - 1), (Context)this.context);
        } else {
            if (name.length() != i + 1) {
                throw new ClassNotFoundException(name);
            }
            clazz = this.primitiveType(name.charAt(i));
        }
        int[] dim = new int[i];
        for (int j = 0; j < i; ++j) {
            dim[j] = 0;
        }
        return Array.newInstance(clazz, dim).getClass();
    }

    private Class primitiveType(char ch) {
        switch (ch) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("boolean", Boolean.TYPE);
    }
}

