/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.pnuts.lib.PathHelper;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

class open
extends PnutsFunction {
    public open() {
        super("open");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2;
    }

    static File getFile(Object input, Context context) {
        File file;
        if (input instanceof String) {
            file = PathHelper.getFile((String)input, context);
        } else if (input instanceof File) {
            file = (File)input;
        } else {
            throw new IllegalArgumentException(String.valueOf(input));
        }
        if (file.getPath().length() == 0) {
            throw new PnutsException("pnuts.io.errors", "empty.fileName", new Object[0], context);
        }
        return file;
    }

    protected Object exec(Object[] args, Context context) {
        int nargs = args.length;
        try {
            if (nargs == 1) {
                Object arg0 = args[0];
                if (arg0 instanceof InputStream) {
                    return arg0;
                }
                if (arg0 instanceof URL) {
                    return ((URL)arg0).openStream();
                }
                File file = open.getFile(args[0], context);
                return new BufferedInputStream(new FileInputStream(file));
            }
            if (nargs == 2) {
                Object input = args[0];
                Object mode = args[1];
                if ("r".equals(mode) || "R".equals(mode)) {
                    if (input instanceof InputStream) {
                        return input;
                    }
                    if (input instanceof URL) {
                        return ((URL)input).openStream();
                    }
                    File file = open.getFile(input, context);
                    return new BufferedInputStream(new FileInputStream(file));
                }
                if ("w".equals(mode) || "W".equals(mode)) {
                    if (input instanceof OutputStream) {
                        return input;
                    }
                    if (input instanceof URL) {
                        URLConnection con = ((URL)input).openConnection();
                        con.setDoOutput(true);
                        return con.getOutputStream();
                    }
                    File file = open.getFile(input, context);
                    PathHelper.ensureBaseDirectory(file);
                    return new BufferedOutputStream(new FileOutputStream(file));
                }
                if ("a".equals(mode) || "A".equals(mode)) {
                    if (input instanceof URL) {
                        throw new IllegalArgumentException(String.valueOf(input));
                    }
                    File file = open.getFile(input, context);
                    PathHelper.ensureBaseDirectory(file);
                    return new BufferedOutputStream(new FileOutputStream(file.toString(), true));
                }
                throw new IllegalArgumentException(String.valueOf(mode));
            }
            this.undefined(args, context);
            return null;
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public String toString() {
        return "function open((String|File|URL) {, (\"r\"|\"w\"|\"a\") } )";
    }
}

