/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.pnuts.lib.PathHelper;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

public class read
extends PnutsFunction {
    private static final Object DEFAULT_STREAM = new Object();

    public read() {
        super("read");
    }

    public boolean defined(int narg) {
        return narg == 1 || narg == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object exec(Object[] args, Context context) {
        Object a1 = null;
        Object a2 = null;
        int nargs = args.length;
        if (nargs == 1) {
            a1 = args[0];
            a2 = DEFAULT_STREAM;
        } else if (nargs == 2) {
            a1 = args[0];
            a2 = args[1];
        } else {
            this.undefined(args, context);
        }
        int nread = 0;
        InputStream in = null;
        OutputStream out = null;
        Reader reader2 = null;
        Writer writer2 = null;
        InputStream inputStreamToClose = null;
        OutputStream outputStreamToClose = null;
        boolean a1isInputStream = false;
        boolean a1isReader = false;
        try {
            if (a1 instanceof InputStream) {
                a1isInputStream = true;
                in = (InputStream)a1;
            } else if (a1 instanceof File) {
                a1isInputStream = true;
                in = inputStreamToClose = new FileInputStream((File)a1);
            } else if (a1 instanceof String) {
                a1isInputStream = true;
                inputStreamToClose = in = new FileInputStream(PathHelper.getFile((String)a1, context));
            } else if (a1 instanceof URL) {
                a1isInputStream = true;
                inputStreamToClose = in = ((URL)a1).openStream();
            } else {
                if (!(a1 instanceof Reader)) throw new IllegalArgumentException(String.valueOf(a1));
                a1isReader = true;
                reader2 = (Reader)a1;
            }
            boolean a2isOutputStream = false;
            boolean a2isWriter = false;
            if (a2 instanceof OutputStream) {
                a2isOutputStream = true;
                out = (OutputStream)a2;
            } else if (a2 instanceof File) {
                a2isOutputStream = true;
                out = outputStreamToClose = new FileOutputStream((File)a2);
            } else if (a2 instanceof String) {
                a2isOutputStream = true;
                outputStreamToClose = out = new FileOutputStream(PathHelper.getFile((String)a2, context));
            } else if (a2 instanceof Writer) {
                a2isWriter = true;
                writer2 = (Writer)a2;
            } else if (a2 != DEFAULT_STREAM) {
                throw new IllegalArgumentException(String.valueOf(a2));
            }
            if (a1isInputStream) {
                if (a2 == DEFAULT_STREAM) {
                    a2 = context.getOutputStream();
                    if (a2 == null) {
                        writer2 = context.getWriter();
                        a2isWriter = true;
                    } else {
                        out = (OutputStream)a2;
                        a2isOutputStream = true;
                    }
                }
                if (a2isOutputStream) {
                    int n;
                    byte[] byArray = new byte[8192];
                    while ((n = in.read(byArray, 0, byArray.length)) >= 0) {
                        out.write(byArray, 0, n);
                        nread += n;
                    }
                    out.flush();
                } else if (a2isWriter) {
                    int n;
                    CountingInputStream countingInputStream = new CountingInputStream(in);
                    char[] buf = new char[8192];
                    reader2 = new InputStreamReader(countingInputStream);
                    while ((n = reader2.read(buf, 0, buf.length)) >= 0) {
                        writer2.write(buf, 0, n);
                    }
                    nread += countingInputStream.count();
                    writer2.flush();
                } else {
                    int n;
                    if (a2 != null) throw new IllegalArgumentException();
                    byte[] byArray = new byte[8192];
                    while ((n = in.read(byArray, 0, byArray.length)) >= 0) {
                        nread += n;
                    }
                }
            } else {
                if (!a1isReader) throw new IllegalArgumentException();
                if (a2 == DEFAULT_STREAM) {
                    a2 = context.getWriter();
                    a2isWriter = true;
                }
                char[] cArray = new char[8192];
                if (a2isOutputStream) {
                    int n;
                    writer2 = new OutputStreamWriter((OutputStream)a2);
                    while ((n = reader2.read(cArray, 0, cArray.length)) >= 0) {
                        writer2.write(cArray, 0, n);
                        nread += n;
                    }
                    writer2.flush();
                } else if (a2isWriter) {
                    int n;
                    while ((n = reader2.read(cArray, 0, cArray.length)) >= 0) {
                        writer2.write(cArray, 0, n);
                        nread += n;
                    }
                    writer2.flush();
                } else {
                    int n;
                    if (a2 != null) throw new IllegalArgumentException();
                    while ((n = reader2.read(cArray, 0, cArray.length)) >= 0) {
                        nread += n;
                    }
                }
            }
            Integer n = new Integer(nread);
            return n;
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
        finally {
            if (inputStreamToClose != null) {
                try {
                    inputStreamToClose.close();
                }
                catch (IOException e) {}
            }
            if (outputStreamToClose != null) {
                try {
                    outputStreamToClose.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String toString() {
        return "function read(input, output)";
    }

    static class CountingInputStream
    extends FilterInputStream {
        int nread = 0;

        public CountingInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int c = this.in.read();
            if (c != -1) {
                ++this.nread;
            }
            return c;
        }

        public int read(byte[] buf, int offset, int len) throws IOException {
            int n = this.in.read(buf, offset, len);
            if (n >= 0) {
                this.nread += n;
            }
            return n;
        }

        public int count() {
            return this.nread;
        }
    }
}

