/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import pnuts.io.TextReader;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

class readText
extends PnutsFunction {
    private final String READER_SYMBOL = "reader".intern();

    public readText() {
        super("readText");
    }

    public boolean defined(int narg) {
        return narg == 1 || narg == 2;
    }

    protected Object exec(Object[] args, Context context) {
        int narg = args.length;
        if (narg != 1 && narg != 2) {
            this.undefined(args, context);
            return null;
        }
        StringWriter sw = new StringWriter();
        Object input = args[0];
        try {
            if (input instanceof Reader) {
                return TextReader.getText((Reader)input, false);
            }
            if (input instanceof InputStream) {
                PnutsFunction readerFunc = (PnutsFunction)context.resolveSymbol(this.READER_SYMBOL);
                Reader reader2 = (Reader)readerFunc.call(args, context);
                return TextReader.getText(reader2, false);
            }
            if (input instanceof String) {
                File f = new File((String)input);
                if (args.length == 2) {
                    return TextReader.getText(f, (String)args[1]);
                }
                PnutsFunction readerFunc = (PnutsFunction)context.resolveSymbol(this.READER_SYMBOL);
                Reader reader3 = (Reader)readerFunc.call(args, context);
                return TextReader.getText(reader3, (int)(f.length() / 2L), true);
            }
            if (input instanceof File) {
                File f = (File)input;
                if (args.length == 2) {
                    return TextReader.getText(f, (String)args[1]);
                }
                PnutsFunction readerFunc = (PnutsFunction)context.resolveSymbol(this.READER_SYMBOL);
                Reader reader4 = (Reader)readerFunc.call(args, context);
                return TextReader.getText(reader4, (int)(f.length() / 2L), true);
            }
            if (input instanceof URL) {
                URL url = (URL)input;
                if (args.length == 2) {
                    return TextReader.getText(new InputStreamReader(url.openStream(), (String)args[1]), true);
                }
                PnutsFunction readerFunc = (PnutsFunction)context.resolveSymbol(this.READER_SYMBOL);
                Reader reader5 = (Reader)readerFunc.call(args, context);
                return TextReader.getText(reader5, true);
            }
            throw new IllegalArgumentException(String.valueOf(input));
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semi = contentType.indexOf(59);
        if (semi == -1) {
            return null;
        }
        int charsetLocation = contentType.indexOf("charset=", semi);
        if (charsetLocation == -1) {
            return null;
        }
        return contentType.substring(charsetLocation + 8).replace('\"', ' ').trim();
    }

    public String toString() {
        return "function readText(InputStream|Reader|String|File|URL {, encoding })";
    }
}

