/*
 * Decompiled with CFR 0.152.
 */
package pnuts.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.pnuts.lib.PathHelper;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

class writer
extends PnutsFunction {
    public writer() {
        super("writer");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2;
    }

    static PrintWriter getWriter(OutputStream output) {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(output)));
    }

    static PrintWriter getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(output, encoding)));
    }

    static PrintWriter getWriter(Object output, Context context) throws IOException {
        if (output instanceof PrintWriter) {
            return (PrintWriter)output;
        }
        if (output instanceof Writer) {
            return new PrintWriter((Writer)output);
        }
        if (output instanceof OutputStream) {
            return writer.getWriter((OutputStream)output);
        }
        if (output instanceof File) {
            File file = (File)output;
            PathHelper.ensureBaseDirectory(file);
            return writer.getWriter(new FileOutputStream(file));
        }
        if (output instanceof String) {
            File file = PathHelper.getFile((String)output, context);
            PathHelper.ensureBaseDirectory(file);
            return writer.getWriter(new FileOutputStream(file));
        }
        throw new IllegalArgumentException(String.valueOf(output));
    }

    static PrintWriter getWriter(Object output, String encoding, Context context) throws IOException {
        if (output instanceof PrintWriter) {
            return (PrintWriter)output;
        }
        if (output instanceof Writer) {
            return new PrintWriter((Writer)output);
        }
        if (output instanceof OutputStream) {
            return writer.getWriter((OutputStream)output, encoding);
        }
        if (output instanceof File) {
            File file = (File)output;
            PathHelper.ensureBaseDirectory(file);
            return writer.getWriter(new FileOutputStream(file), encoding);
        }
        if (output instanceof String) {
            File file = PathHelper.getFile((String)output, context);
            PathHelper.ensureBaseDirectory(file);
            return writer.getWriter(new FileOutputStream(file), encoding);
        }
        throw new IllegalArgumentException(String.valueOf(output));
    }

    protected Object exec(Object[] args, Context context) {
        int nargs = args.length;
        try {
            if (nargs == 1) {
                return writer.getWriter(args[0], context);
            }
            if (nargs == 2) {
                return writer.getWriter(args[0], (String)args[1], context);
            }
            this.undefined(args, context);
            return null;
        }
        catch (IOException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public String toString() {
        return "function writer((Writer|OutputStream|String|File) {, encoding } )";
    }
}

