/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import pnuts.compiler.ClassFile;
import pnuts.lib.ClassFileLoader;

public class BeanClassGenerator {
    public static ClassFile generateClassFile(Map typeMap, String className, String superClassName, String[] interfaces, String[] constructorParams) {
        if (superClassName == null) {
            superClassName = "java.lang.Object";
        }
        ClassFile cf = new ClassFile(className, superClassName, null, 1);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                cf.addInterface(interfaces[i]);
            }
        }
        cf.openMethod("<init>", "()V", (short)1);
        cf.add((byte)42);
        cf.add((byte)-73, superClassName, "<init>", "()", "V");
        cf.add((byte)-79);
        cf.closeMethod();
        if (constructorParams != null) {
            Class type;
            String param;
            int i;
            boolean constructorParamsAreValid = true;
            StringBuffer sbuf = new StringBuffer("(");
            for (i = 0; i < constructorParams.length; ++i) {
                param = constructorParams[i];
                type = (Class)typeMap.get(param);
                if (type == null) {
                    constructorParamsAreValid = false;
                    break;
                }
                sbuf.append(ClassFile.signature((Class)type));
            }
            if (constructorParamsAreValid) {
                sbuf.append(")V");
                cf.openMethod("<init>", sbuf.toString(), (short)1);
                cf.add((byte)42);
                cf.add((byte)-73, superClassName, "<init>", "()", "V");
                for (i = 0; i < constructorParams.length; ++i) {
                    cf.add((byte)42);
                    param = constructorParams[i];
                    type = (Class)typeMap.get(param);
                    if (type.isPrimitive()) {
                        BeanClassGenerator.loadPrimitive(cf, type, i + 1);
                    } else {
                        cf.loadLocal(i + 1);
                    }
                    cf.add((byte)-75, cf.getClassName(), param, ClassFile.signature((Class)type));
                }
                cf.add((byte)-79);
                cf.closeMethod();
            }
        }
        Iterator it = typeMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Class type = (Class)entry.getValue();
            BeanClassGenerator.emit(cf, key, type);
        }
        return cf;
    }

    private static void loadPrimitive(ClassFile cf, Class primitive, int index) {
        if (primitive == Integer.TYPE) {
            cf.iloadLocal(index);
        } else if (primitive == Byte.TYPE) {
            cf.iloadLocal(index);
        } else if (primitive == Short.TYPE) {
            cf.iloadLocal(index);
        } else if (primitive == Character.TYPE) {
            cf.iloadLocal(index);
        } else if (primitive == Long.TYPE) {
            cf.lloadLocal(index);
        } else if (primitive == Float.TYPE) {
            cf.floadLocal(index);
        } else if (primitive == Double.TYPE) {
            cf.dloadLocal(index);
        } else if (primitive == Boolean.TYPE) {
            cf.iloadLocal(index);
        }
    }

    static void emit(ClassFile cf, String propertyName, Class type) {
        cf.addField(propertyName, ClassFile.signature((Class)type), (short)2);
        cf.openMethod(BeanClassGenerator.getterName(propertyName, type), BeanClassGenerator.makeSignature(null, type), (short)1);
        cf.add((byte)42);
        cf.add((byte)-76, cf.getClassName(), propertyName, ClassFile.signature((Class)type));
        if (!type.isPrimitive()) {
            cf.add((byte)-80);
        } else if (type == Long.TYPE) {
            cf.add((byte)-83);
        } else if (type == Float.TYPE) {
            cf.add((byte)-82);
        } else if (type == Double.TYPE) {
            cf.add((byte)-81);
        } else {
            cf.add((byte)-84);
        }
        cf.closeMethod();
        cf.openMethod(BeanClassGenerator.setterName(propertyName), BeanClassGenerator.makeSignature(type, Void.TYPE), (short)1);
        cf.add((byte)42);
        if (!type.isPrimitive()) {
            cf.add((byte)43);
        } else if (type == Long.TYPE) {
            cf.add((byte)31);
        } else if (type == Float.TYPE) {
            cf.add((byte)35);
        } else if (type == Double.TYPE) {
            cf.add((byte)39);
        } else {
            cf.add((byte)27);
        }
        cf.add((byte)-75, cf.getClassName(), propertyName, ClassFile.signature((Class)type));
        cf.add((byte)-79);
        cf.closeMethod();
    }

    static String capitalize(String s) {
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    static String getterName(String property, Class type) {
        if (type == Boolean.TYPE) {
            return "is" + BeanClassGenerator.capitalize(property);
        }
        return "get" + BeanClassGenerator.capitalize(property);
    }

    static String setterName(String property) {
        return "set" + BeanClassGenerator.capitalize(property);
    }

    static String makeSignature(Class type, Class returnType) {
        StringBuffer sbuf = new StringBuffer();
        if (type == null) {
            sbuf.append("()");
        } else {
            sbuf.append(ClassFile.signature((Class[])new Class[]{type}));
        }
        if (returnType == Void.TYPE) {
            sbuf.append('V');
        } else {
            sbuf.append(ClassFile.signature((Class)returnType));
        }
        return sbuf.toString();
    }

    public static Class generate(Map typeMap, String className, String superClassName, String[] interfaces) throws IOException {
        return BeanClassGenerator.generate(typeMap, className, superClassName, interfaces, Thread.currentThread().getContextClassLoader());
    }

    public static Class generate(Map typeMap, String className, String superClassName, String[] interfaces, ClassLoader loader) throws IOException {
        ClassFile cf = BeanClassGenerator.generateClassFile(typeMap, className, superClassName, interfaces, null);
        return new ClassFileLoader(loader).define(cf);
    }

    public static void generate(Map typeMap, String className, String superClassName, String[] interfaces, OutputStream out) throws IOException {
        ClassFile cf = BeanClassGenerator.generateClassFile(typeMap, className, superClassName, interfaces, null);
        cf.write(out);
    }
}

