/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.util.Calendar;
import java.util.Date;
import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;
import pnuts.lib.date;

class DateElementDiff
extends PnutsFunction {
    private int element;

    DateElementDiff(int element2, String name) {
        super(name);
        this.element = element2;
    }

    public boolean defined(int nargs) {
        return nargs == 2;
    }

    static int diffYear(Calendar c0, Calendar c1) {
        return c1.get(1) - c0.get(1);
    }

    static int diffMonth(Calendar c0, Calendar c1) {
        return DateElementDiff.diffYear(c1, c0) * 12 + c1.get(2) - c0.get(2);
    }

    static int diffHour(Calendar c0, Calendar c1) {
        return DateElementDiff.diffDay(c0, c1) * 24 + c1.get(10) - c0.get(10);
    }

    static int diffMinute(Calendar c0, Calendar c1) {
        return DateElementDiff.diffHour(c0, c1) * 60 + c1.get(12) - c0.get(12);
    }

    static long diffSecond(Calendar c0, Calendar c1) {
        return (long)DateElementDiff.diffMinute(c0, c1) * 60L + (long)c1.get(13) - (long)c0.get(13);
    }

    static long diffMilliSecond(Calendar c0, Calendar c1) {
        return DateElementDiff.diffSecond(c0, c1) * 1000L + (long)c1.get(14) - (long)c0.get(14);
    }

    static int diffDay(Calendar c0, Calendar c1) {
        boolean negative;
        int year0 = c0.get(1);
        int day0 = c0.get(6);
        int year1 = c1.get(1);
        int day1 = c1.get(6);
        if (year0 == year1) {
            return day1 - day0;
        }
        if (year0 > year1) {
            int tmp = year0;
            year0 = year1;
            year1 = tmp;
            tmp = day0;
            day0 = day1;
            day1 = tmp;
            negative = true;
        } else {
            negative = false;
        }
        Calendar c = (Calendar)c0.clone();
        c.set(year0, 11, 31);
        int days = c.get(6) - day0;
        for (int i = year0 + 1; i < year1; ++i) {
            c.set(i, 11, 31);
            days += c.get(6);
        }
        days += day1;
        if (negative) {
            return -days;
        }
        return days;
    }

    static int diffWeekOfYear(Calendar c0, Calendar c1) {
        int firstDay;
        int w;
        int days = DateElementDiff.diffDay(c0, c1);
        if (days < 0) {
            w = c1.get(7);
            firstDay = c0.getFirstDayOfWeek();
        } else {
            w = c0.get(7);
            firstDay = c0.getFirstDayOfWeek();
        }
        return (days - (7 - (w - firstDay) % 7)) / 7 + 1;
    }

    protected Object exec(Object[] args, Context context) {
        if (args.length != 2) {
            this.undefined(args, context);
            return null;
        }
        Calendar c0 = date.getCalendar((Date)args[0], context);
        Calendar c1 = date.getCalendar((Date)args[1], context);
        switch (this.element) {
            case 1: {
                return new Integer(DateElementDiff.diffYear(c0, c1));
            }
            case 2: {
                return new Integer(DateElementDiff.diffMonth(c0, c1));
            }
            case 3: {
                return new Integer(DateElementDiff.diffWeekOfYear(c0, c1));
            }
            case 6: {
                return new Integer(DateElementDiff.diffDay(c0, c1));
            }
            case 11: {
                return new Integer(DateElementDiff.diffHour(c0, c1));
            }
            case 12: {
                return new Integer(DateElementDiff.diffMinute(c0, c1));
            }
            case 13: {
                long l = DateElementDiff.diffSecond(c0, c1);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return new Long(l);
                }
                return new Integer((int)l);
            }
            case 14: {
                long l = DateElementDiff.diffMilliSecond(c0, c1);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return new Long(l);
                }
                return new Integer((int)l);
            }
        }
        throw new IllegalArgumentException(String.valueOf(this.element));
    }

    public String toString() {
        return "function " + this.name + "(Date, Date)";
    }
}

